DELIMITER $$
DROP PROCEDURE IF EXISTS V20251202154340__Insert_uiTransCreditUnit $$
CREATE PROCEDURE V20251202154340__Insert_uiTransCreditUnit()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='GRANTED_CREDIT_UNIT' and objectName='PERSON')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','GRANTED_CREDIT_UNIT','Granted Credit Unit','Granted Credit Unit','Toegekende kredieteenheid','Đơn vị tín dụng được cấp',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='GRANTED_CREDIT_UNIT' and objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS','GRANTED_CREDIT_UNIT','Granted Credit Unit','Granted Credit Unit','Toegekende kredieteenheid','Đơn vị tín dụng được cấp',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='USED_CREDIT_UNIT' and objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS','USED_CREDIT_UNIT','Used Credit Unit','Used Credit Unit','Gebruikte kredieteenheid','Đơn vị tín dụng đã sử dụng',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='AVAILABLE_CREDIT_UNIT' and objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS','AVAILABLE_CREDIT_UNIT','Available Credit Unit','Available Credit Unit','Beskikbare kredieteenheid','Đơn vị tín dụng có sẵn',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='PREVIOUSLY_USED_CU' and objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS','PREVIOUSLY_USED_CU','Previously Used CU','Previously Used CU','Voorheen gebruik CU','CU đã sử dụng trước đây',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='AMOUNT_PER_CREDIT_UNIT' and objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS','AMOUNT_PER_CREDIT_UNIT','Amount Per Credit Unit','Amount Per Credit Unit','Bedrag per kredieteenheid','Số tiền trên mỗi đơn vị tín chỉ',now(),1);
END IF;

END $$
CALL V20251202154340__Insert_uiTransCreditUnit() $$
DROP PROCEDURE IF EXISTS V20251202154340__Insert_uiTransCreditUnit $$
DELIMITER ;