DELIMITER $$
DROP PROCEDURE IF EXISTS V20251205115759__Insert_ProofOfRegistrationTemplateSUSS $$
CREATE PROCEDURE V20251205115759__Insert_ProofOfRegistrationTemplateSUSS()
BEGIN


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'PROOF_OF_REGISTRATION_SUSS')) THEN 
set @proof = (select id from report_type WHERE typeName = 'Basic Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@proof, 'PROOF_OF_REGISTRATION_SUSS', 'SUSS - Proof of Registration', 'PROOF_OF_REGISTRATION_SUSS.png', 'PROOF_OF_REGISTRATION_SUSS_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'PROOF_OF_REGISTRATION_SUSS.jasper', 'AcademiaLogo.png'); 
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'PROOF_OF_REGISTRATION_SUSS')) THEN 
set @reg = (select max(id) from `report_template` WHERE templateCode = 'PROOF_OF_REGISTRATION_SUSS');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_STD_ENROLLED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_STD_ENROLLED', 'Student Enrollment for', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_STD_PERS_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_STD_PERS_DETAILS', 'Student Personal Details', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_STUDENT_ID', 'Student  ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_DATE_OF_BIRTH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_DATE_OF_BIRTH', 'Date of Birth', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_STDNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_STDNO', 'Student number', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_QUALIFICATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_QUALIFICATION', 'Qualification Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_INTAKE_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_INTAKE_YEAR', 'Intake', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_OFFERING_TYPE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_OFFERING_TYPE', 'Offering Type', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_SUBJECT_ENROLLMENT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_SUBJECT_ENROLLMENT_DETAILS', 'Subject Enrollment Details', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_DATE', 'Date :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reg and keyValue='TRANS_PAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reg, 'TRANS_PAGE', 'Page :', '1', now());
END IF;


END $$
CALL V20251205115759__Insert_ProofOfRegistrationTemplateSUSS() $$
DROP PROCEDURE IF EXISTS V20251205115759__Insert_ProofOfRegistrationTemplateSUSS $$
DELIMITER ;