DELIMITER $$
DROP PROCEDURE IF EXISTS V20251205123709__Create_NServiceStatus $$
CREATE PROCEDURE V20251205123709__Create_NServiceStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='national_service_status')) THEN 
		
		CREATE TABLE `national_service_status`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,	
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		UNIQUE `national_service_status_UNIQUE`(itemCode),
		CONSTRAINT `national_service_status_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master where tableName='national_service_status' AND masterName='NATIONAL_SERVICE_STATUS')) THEN
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@standardMasterMaxId+1,'national_service_status', 'NATIONAL_SERVICE_STATUS', 'Admissions', 'COMMON_MASTER', 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@ItemsMaxId + 1,'itemCode', 'ITEM_CODE', @standardMasterMaxId+1 , 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId + 1,'itemValue', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
	END IF;
    
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'NATIONAL_SERVICE_STATUS')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'NATIONAL_SERVICE_STATUS', 'National Service Status', 'National Service Status','Nasionale Diens Naam','Tên nghĩa vụ quốc gia',now(),1);
	END IF; 

END $$
CALL V20251205123709__Create_NServiceStatus () $$ 
DROP PROCEDURE IF EXISTS V20251205123709__Create_NServiceStatus $$ 
DELIMITER ;