DELIMITER $$
DROP PROCEDURE IF EXISTS V20251210150213__Alter_FeesGrantHeader $$
CREATE PROCEDURE V20251210150213__Alter_FeesGrantHeader()
BEGIN

IF  EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='grantedCU')) THEN 
alter table `fees_grant_header` MODIFY  column `grantedCU` decimal(19,2) DEFAULT NULL;
END IF; 
IF  EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='availableCU')) THEN 
alter table `fees_grant_header` MODIFY  column `availableCU` decimal(19,2) DEFAULT NULL;
END IF; 
IF  EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='totalUsedCU')) THEN 
alter table `fees_grant_header` MODIFY  column `totalUsedCU` decimal(19,2) DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='tuitionCreditGrantedById')) THEN 
ALTER TABLE `fees_grant_header`
ADD COLUMN `tuitionCreditGrantedById` BIGINT(20) NULL AFTER `programBatchSeatConfigId`,
ADD KEY `ReftuitionCreditGrantedBy_idx` (`tuitionCreditGrantedById`),
ADD CONSTRAINT `ReftuitionCreditGrantedById_ghd` FOREIGN KEY (`tuitionCreditGrantedById`) REFERENCES `tuition_credit_granted_by` (`id`)
 ON DELETE NO ACTION ON UPDATE NO ACTION;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='bufferCU')) THEN 
ALTER TABLE `fees_grant_header`
ADD COLUMN `bufferCU` decimal(19,2) DEFAULT NULL AFTER `totalUsedCU`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='bufferPerUnitAmount')) THEN 
ALTER TABLE `fees_grant_header`
ADD COLUMN `bufferPerUnitAmount` decimal(19,2) DEFAULT NULL AFTER `bufferCU`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fees_grant_header' AND column_name='availableBufferCU')) THEN 
ALTER TABLE `fees_grant_header`
ADD COLUMN `availableBufferCU` decimal(19,2) DEFAULT NULL AFTER `bufferPerUnitAmount`;
END IF;

END $$
CALL V20251210150213__Alter_FeesGrantHeader() $$
DROP PROCEDURE IF EXISTS V20251210150213__Alter_FeesGrantHeader $$
DELIMITER ;