DELIMITER $$
DROP PROCEDURE IF EXISTS V20251227142137__Update_ProofOfRegistrationTemplateSUSS $$
CREATE PROCEDURE V20251227142137__Update_ProofOfRegistrationTemplateSUSS()
BEGIN

SET SQL_SAFE_UPDATES = 0;

SET @tempId = (
    SELECT MAX(id)
    FROM report_template
    WHERE templateCode = 'PROOF_OF_REGISTRATION_SUSS'
      AND templateName = 'SUSS - Proof of Registration'
    LIMIT 1
);

/* TRANS_STD_PERS_DETAILS */
UPDATE report_template_translations
SET defaultValue = 'Student Invoice',
    lastUpdatedBy = '1',
    lastUpdate = NOW()
WHERE reportTemplateId = @tempId
  AND keyValue = 'TRANS_STD_PERS_DETAILS';

/* TRANS_STDNO */
UPDATE report_template_translations
SET defaultValue = 'Residency Status',
    lastUpdatedBy = '1',
    lastUpdate = NOW()
WHERE reportTemplateId = @tempId
  AND keyValue = 'TRANS_STDNO';

/* TRANS_QUALIFICATION */
UPDATE report_template_translations
SET defaultValue = 'Program',
    lastUpdatedBy = '1',
    lastUpdate = NOW()
WHERE reportTemplateId = @tempId
  AND keyValue = 'TRANS_QUALIFICATION';

/* TRANS_SUBJECT_ENROLLMENT_DETAILS */
UPDATE report_template_translations
SET defaultValue = 'Invoice Details',
    lastUpdatedBy = '1',
    lastUpdate = NOW()
WHERE reportTemplateId = @tempId
  AND keyValue = 'TRANS_SUBJECT_ENROLLMENT_DETAILS';

SET SQL_SAFE_UPDATES = 1;

END $$

CALL V20251227142137__Update_ProofOfRegistrationTemplateSUSS() $$
DROP PROCEDURE IF EXISTS V20251227142137__Update_ProofOfRegistrationTemplateSUSS $$
DELIMITER ;
