DELIMITER $$
DROP PROCEDURE IF EXISTS V20260106194759__Insert_SpecializationRequestSubNotiStudent $$
CREATE PROCEDURE V20260106194759__Insert_SpecializationRequestSubNotiStudent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='Specialization Request Submission Notification for Student')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='PROGRAM_AND_COURSE');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Specialization Request Submission Notification for Student');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Specialization Request Submission Notification for Student');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT', 'Specialization Request Submission Notification for Student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Specialization Request Submission Notification for Student');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM student_specialization_enrollment T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT 
    T1.id AS ID,
    T9.firstName AS FIRST_NAME,
    T9.middleName AS MIDDLE_NAME,
    T9.lastName AS LAST_NAME,
    T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T3.code AS STUDENT_ID,
    T3.printName AS STUDENT_PRINT_NAME,
    T7.programName AS PROGRAM_NAME,
    T7.programCode AS PROGRAM_CODE,
    T6.printName AS BATCH_NAME,
    T5.specializationName AS SPECIALIZATION_NAME,
    T10.displayName AS ACADEMY_LOCATION_NAME
FROM
    student_specialization_enrollment T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    users T3 ON T2.studentId = T3.id
        LEFT JOIN
    students T8 ON T3.id = T8.userId
        LEFT JOIN
    persons T9 ON T8.personId = T9.id
        LEFT JOIN
    prog_batch_course_special T4 ON T1.programBatchCourseSpecialId = T4.id
        LEFT JOIN
    specialization T5 ON T4.specializationId = T5.id
        LEFT JOIN
    batches T6 ON T4.programBatchId = T6.id
        LEFT JOIN
    programs T7 ON T6.programId = T7.id
        LEFT JOIN
    academy_location T10 ON T2.academyLocationId = T10.id
WHERE
    T1.id IN (namedParams) and approveStatus='Pending'",'{
     "id": 1,
     "searchResultViewColumns": [        
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		{
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },{
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "programCode",
            "resultKey": "PROGRAM_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "printName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "specializationName",
            "resultKey": "SPECIALIZATION_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Specialization Request Submission Notification for Student');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SPECIALIZATION_REQUEST_SUBMISSION_NOTIFICATION_FOR_STUDENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Specialization Request Submission Notification for Student Email',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Specialization Request Submission Notification for Student Email',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Confirmation of Your Specialization Request Submission','<html>
<head>
	<title></title>
</head>
<body>
<p>Dear,<br />
<br />
We are pleased to inform you that your Specialization Request has been successfully submitted for review. Our team will now process your request and you will be notified once it has been reviewed.<br />
<br />
Please allow some time for the evaluation process. If we require any further information from you, we will reach out directly.<br />
<br />
<br />
Thank you for your submission.<br />
<br />
Best regards,</p>
</body>
</html>
');
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Confirmation of Your Specialization Request Submission','<html>
<head>
	<title></title>
</head>
<body>
<p>Dear,<br />
<br />
We are pleased to inform you that your Specialization Request has been successfully submitted for review. Our team will now process your request and you will be notified once it has been reviewed.<br />
<br />
Please allow some time for the evaluation process. If we require any further information from you, we will reach out directly.<br />
<br />
<br />
Thank you for your submission.<br />
<br />
Best regards,</p>
</body>
</html>
');
 

-- End Messaging for Specialization Request Submission Notification for Student Event
END IF;


END $$
CALL V20260106194759__Insert_SpecializationRequestSubNotiStudent() $$
DROP PROCEDURE IF EXISTS V20260106194759__Insert_SpecializationRequestSubNotiStudent $$
DELIMITER ;