DELIMITER $$
DROP PROCEDURE IF EXISTS V20260106221835__Update_dataGridForSepcilizationGrid $$
CREATE PROCEDURE V20260106221835__Update_dataGridForSepcilizationGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName="Academia.view.program.StudentSpecialEnrollmentGrid" and portalId=1)) THEN 
update data_grid set `jsonObject`='[{"id":null,"columnName":"ADMISSION_CODE","dataIndex":"admissionCode","columnVisibility":"HIDE","sequence":1,"mandatory":false},
 {"id":null,"columnName":"STUDENT_CODE","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
 {"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
 {"id":null,"columnName":"SPECIALIZATION","dataIndex":"specializationCode","columnVisibility":"SHOW","sequence":4,"mandatory":false},
 {"id":null,"columnName":"STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":5,"mandatory":false},
 {"id":null,"columnName":"REQUEST_DATE","dataIndex":"requestDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
 {"id":null,"columnName":"APPROVED_BY","dataIndex":"approveBy","columnVisibility":"SHOW","sequence":7,"mandatory":false},
 {"id":null,"columnName":"APPROVAL_DATE","dataIndex":"approvedDateString","columnVisibility":"SHOW","sequence":8,"mandatory":false}]'
where gridName='Academia.view.program.StudentSpecialEnrollmentGrid' and portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='SPECIALIZATION_ENROLLMENT')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','SPECIALIZATION_ENROLLMENT','Specialization Enrollment','Specialization Enrollment','Spesialiseringsinskrywing','Đăng ký chuyên ngành',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='PROGRAMANDCOURSE' AND keyName='REQUEST_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PROGRAMANDCOURSE','REQUEST_DATE','Request Date','Request Date','Versoekdatum','Ngày yêu cầu',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='PROGRAMANDCOURSE' AND keyName='APPROVED_BY')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PROGRAMANDCOURSE','APPROVED_BY','Approved  By','Approved  By','Goedgekeur deur','Được phê duyệt bởi',now(),1);
END IF; 

 IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='PROGRAMANDCOURSE' AND keyName='APPROVAL_DATE')) THEN
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('PROGRAMANDCOURSE','APPROVAL_DATE','Approval Date','Approval Date','Goedkeuringsdatum','Ngày phê duyệt',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='student_specialization_enrollment' AND column_name='requestDate ')) THEN 
ALTER TABLE student_specialization_enrollment
ADD COLUMN requestDate DATE NULL;
END IF;
END $$
CALL V20260106221835__Update_dataGridForSepcilizationGrid () $$
DROP PROCEDURE IF EXISTS V20260106221835__Update_dataGridForSepcilizationGrid $$
DELIMITER ;