DELIMITER $$
DROP PROCEDURE IF EXISTS V20260107202119__Create_TuitionCreditWeatherGS $$
CREATE PROCEDURE V20260107202119__Create_TuitionCreditWeatherGS()
BEGIN

IF NOT EXISTS (
    SELECT 1
    FROM information_schema.COLUMNS
    WHERE table_schema = DATABASE()
      AND table_name = 'tuition_credit_granted_by'
      AND column_name = 'weatherGovernmentSubsidy'
) THEN
    ALTER TABLE tuition_credit_granted_by
    ADD COLUMN `weatherGovernmentSubsidy` TINYINT(1) NOT NULL DEFAULT 0;
END IF;

IF  EXISTS ((select * from standard_master where tableName = 'tuition_credit_granted_by')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'tuition_credit_granted_by');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='WEATHER_GOVERNMENT_SUBSIDY')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('weatherGovernmentSubsidy','WEATHER_GOVERNMENT_SUBSIDY',@standardMasterId,'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'WEATHER_GOVERNMENT_SUBSIDY')) THEN
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'WEATHER_GOVERNMENT_SUBSIDY', 'weatherGovernmentSubsidy', 'weatherGovernmentSubsidy','weerRegeringsubsidie','thời tiếtTrợ cấp của chính phủ',now(),1);
END IF;

END $$
CALL V20260107202119__Create_TuitionCreditWeatherGS () $$ 
DROP PROCEDURE IF EXISTS V20260107202119__Create_TuitionCreditWeatherGS $$ 
DELIMITER ;