DELIMITER $$
DROP PROCEDURE IF EXISTS V20260119181403__Create_pathwaysRequestApprover $$
CREATE PROCEDURE V20260119181403__Create_pathwaysRequestApprover()

BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='pathways_request_approver')) THEN
CREATE TABLE `pathways_request_approver` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchId` bigint(20) NOT NULL,
  `approverDesignation` Varchar(255) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_approver_batch_Id_idx` (`batchId` ASC),
  INDEX `fk_approver_user_Id_idx` (`userId` ASC),
  INDEX `fk_pathways_approver_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_approver_batch_id` 
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`),
  CONSTRAINT `fk_approver_userId` 
	FOREIGN KEY (`userId`) 
	REFERENCES `users` (`id`) ,
  CONSTRAINT `fk_approver_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
END IF;

END $$
CALL V20260119181403__Create_pathwaysRequestApprover () $$ 
DROP PROCEDURE IF EXISTS V20260119181403__Create_pathwaysRequestApprover $$ 
DELIMITER ;