DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120175659__Create_ProgramBatchPathways $$
CREATE PROCEDURE V20260120175659__Create_ProgramBatchPathways()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_batch_pathways')) THEN
CREATE TABLE `program_batch_pathways` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchId` bigint(20) NOT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_batch_pathways_Id_idx` (`batchId` ASC),
  INDEX `fk_batch_pathways_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_pathways_batch_id` 
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`),
  CONSTRAINT `fk_batch_pathways_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
END IF;

END $$
CALL V20260120175659__Create_ProgramBatchPathways () $$ 
DROP PROCEDURE IF EXISTS V20260120175659__Create_ProgramBatchPathways $$ 
DELIMITER ;