DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120180537__Create_ProgramBatchPathwayschild $$
CREATE PROCEDURE V20260120180537__Create_ProgramBatchPathwayschild()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_batch_pathways_child')) THEN
CREATE TABLE `program_batch_pathways_child` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programBatchPathwaysId` bigint(20) NOT NULL,
  `pathwaysCSMId` bigint(20) NOT NULL,
  `groupCount` bigint(20) NOT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_batch_pathways_child_Id_idx` (`programBatchPathwaysId` ASC),
  INDEX `fk_batch_pathways_csm_child_Id_idx` (`pathwaysCSMId` ASC),
  INDEX `fk_batch_pathways_child_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_pathways_child_batch_id` 
	FOREIGN KEY (`programBatchPathwaysId`)
	REFERENCES `program_batch_pathways` (`id`),
    
    CONSTRAINT `fk_pathways_csm_child_id` 
	FOREIGN KEY (`pathwaysCSMId`)
	REFERENCES `pathwaysCSM` (`id`),
    
  CONSTRAINT `fk_batch_pathways_child_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
END IF;

END $$
CALL V20260120180537__Create_ProgramBatchPathwayschild () $$ 
DROP PROCEDURE IF EXISTS V20260120180537__Create_ProgramBatchPathwayschild $$ 
DELIMITER ;