DELIMITER $$
DROP PROCEDURE IF EXISTS V20260122183444__Alter_stdPathwaysEnrollment $$
CREATE PROCEDURE V20260122183444__Alter_stdPathwaysEnrollment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_pathways_specialization_enrollment')) THEN
CREATE TABLE  `student_pathways_specialization_enrollment` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `requestId` VARCHAR(255) NULL,
    `admissionId` BIGINT(20) NOT NULL,
    `programBatchCourseSpecialId` BIGINT(20) NOT NULL,
    `approveStatus` VARCHAR(45) NULL,
    `approverId` BIGINT(20) DEFAULT NULL, 
    `requestDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `approvedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `assignedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `remark` VARCHAR(255) NULL,
    PRIMARY KEY (`id`),
    INDEX `fk_prog_batch_period_pathways_admissionId_idx` (`admissionId` ASC),
    INDEX `fk_prog_batch_period_pathways_specialId_idx` (`programBatchCourseSpecialId` ASC),
    INDEX `fk_pathways_approver_idx` (`approverId` ASC),
    CONSTRAINT `fk_prog_batch_period_pathways_admissionId` FOREIGN KEY (`admissionId`)
        REFERENCES `admission` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_pathways_groupId` FOREIGN KEY (`programBatchCourseSpecialId`)
        REFERENCES `prog_batch_course_special` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
     CONSTRAINT `fk_pathways_approver_id` FOREIGN KEY (`approverId`)
        REFERENCES `users` (`id`) 
		ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_pathways_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION
);
END IF;

END $$
CALL V20260122183444__Alter_stdPathwaysEnrollment() $$
DROP PROCEDURE IF EXISTS V20260122183444__Alter_stdPathwaysEnrollment $$
DELIMITER ;