DELIMITER $$
DROP PROCEDURE IF EXISTS V20260124151413__Create_speciEnrollentPathways $$
CREATE PROCEDURE V20260124151413__Create_speciEnrollentPathways()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_pathways_specialization_enrollment_child')) THEN
CREATE TABLE  `student_pathways_specialization_enrollment_child` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `sepcializationEnrollmentId` BIGINT(20) NOT NULL,
    `requestId` VARCHAR(255) NULL,
    `admissionId` BIGINT(20) NOT NULL,
    `programBatchCourseSpecialId` BIGINT(20) NOT NULL,
    `approveStatus` VARCHAR(45) NULL,
    `approverId` BIGINT(20) DEFAULT NULL, 
    `currentAssigneeId` BIGINT(20) DEFAULT NULL,
    `requestDate` timestamp DEFAULT NULL,
    `approvedDate` timestamp DEFAULT NULL,
    `assignedDate` timestamp DEFAULT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `remark` VARCHAR(255) NULL,
    `isActive` TINYINT(1) DEFAULT 1, 
    PRIMARY KEY (`id`),
	INDEX `fk_pathways_current_assignee_idx` (`currentAssigneeId` ASC),
    INDEX `fk_prog_batch_period_specialization_enrollment_idx` (`SepcializationEnrollmentId` ASC),
    INDEX `fk_prog_batch_period_pathways_admissionId_child_idx` (`admissionId` ASC),
    INDEX `fk_prog_batch_period_pathways_specialId_child_idx` (`programBatchCourseSpecialId` ASC),
    INDEX `fk_pathways_approver_idx` (`approverId` ASC),
    CONSTRAINT `fk_prog_batch_period_pathways_child_admissionId` FOREIGN KEY (`admissionId`)
        REFERENCES `admission` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_pathways_child_groupId` FOREIGN KEY (`programBatchCourseSpecialId`)
        REFERENCES `prog_batch_course_special` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
     CONSTRAINT `fk_pathways_approver_child_id` FOREIGN KEY (`approverId`)
        REFERENCES `users` (`id`) 
		ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_prog_batch_period_pathways_child_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
   CONSTRAINT `fk_prog_batch_period_specialization_enrollment` FOREIGN KEY (`SepcializationEnrollmentId`)
        REFERENCES `student_pathways_specialization_enrollment` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION ,
     CONSTRAINT `fk_pathways_specialization_enrollment_current_assignee_id`
     FOREIGN KEY (`currentAssigneeId`)
     REFERENCES `users` (`id`)
     ON DELETE NO ACTION ON UPDATE NO ACTION 
);
END IF;

END $$
CALL V20260124151413__Create_speciEnrollentPathways () $$ 
DROP PROCEDURE IF EXISTS V20260124151413__Create_speciEnrollentPathways $$ 
DELIMITER ;