SET FOREIGN_KEY_CHECKS=0;
CREATE TABLE `ApplicationAdmissionDetail` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `applicationProgramId` BIGINT(20)  NOT NULL,
  `academyLocationId` BIGINT(20)  NOT NULL,
  `status` VARCHAR(50) NOT NULL,
  `admissionType` VARCHAR(100) NOT NULL,
  `trialStartDate` TIMESTAMP NULL ,
  `trialEndDate` TIMESTAMP NULL ,
  `provisionalLastDate` TIMESTAMP NULL ,
  `confirmedAdmissionClosureReason` VARCHAR(255) DEFAULT NULL,
  `trialAdmissionClosureReason` VARCHAR(255) DEFAULT NULL,
  `provisionalAdmissionClosureReason` VARCHAR(255) DEFAULT NULL,
  `advisiorId` BIGINT(20) DEFAULT NULL,
  `whetherWithdrawl` TINYINT(1) DEFAULT NULL,
  `whetherDenied` TINYINT(1) DEFAULT NULL,
  `whetherConfirmed` TINYINT(1) DEFAULT NULL,
  `programBatchPeriodConfigId` BIGINT(20) DEFAULT NULL,
  `programBatchSeatConfigId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy_fk` (`lastUpdatedBy`),
  KEY `refApplicationProg1` (`applicationProgramId`),
  KEY `advisiorId_fk` (`advisiorId`),
  KEY `fk_pbpc` (`programBatchPeriodConfigId`),
  KEY `fk_pbsc` (`programBatchSeatConfigId`),
  KEY `fk_academy_location_id1` (`academyLocationId`),
  CONSTRAINT `fk_academy_location_id1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_pbpc` FOREIGN KEY (`programBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_pbsc` FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`),
  CONSTRAINT `refApplicationProg1` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program` (`id`),
  CONSTRAINT `lastUpdatedBy_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `advisiorId_fk` FOREIGN KEY (`advisiorId`) REFERENCES `users` (`id`)
);


ALTER TABLE `admission`
DROP COLUMN `applicationId`, 
 DROP COLUMN `whetherOfferLetterAccepted`,
DROP COLUMN `admissionStatus`,
DROP COLUMN `approverId`,
DROP COLUMN `admission_type`,
DROP COLUMN `receiptId`,
DROP COLUMN `trial_start_date`,
DROP COLUMN `trial_end_date`,
DROP COLUMN `provisional_last_date`,
DROP COLUMN `Confirmed_admission_closure_reason`,
DROP COLUMN `trial_admission_closure_reason`,
DROP COLUMN `provisional_admission_closure_reason`, 
 DROP COLUMN `advisior_id`, 
 DROP COLUMN `whetherWithdrawl`,
DROP COLUMN `whetherDenied`, 
 DROP COLUMN `whetherConfirmed`,
DROP COLUMN `academyLocationId`,
DROP COLUMN `studentId`,
DROP INDEX `Refusers1715`, 
 DROP INDEX `refApplication`, 
 DROP INDEX `refuser_advisor`, 
 DROP FOREIGN KEY `refApplication`,
DROP FOREIGN KEY `Refusers1715`,
DROP FOREIGN KEY `refuser_advisor`,
DROP INDEX `Refstudents2129`,
DROP INDEX `fk_academy_location_id`, 
 DROP FOREIGN KEY `fk_academy_location_id`, 
 DROP FOREIGN KEY `Refstudents2129`; 
 
 
ALTER TABLE `admission`   
  ADD COLUMN `applicationAdmissionId` BIGINT(20) NOT NULL AFTER `id`,
  ADD COLUMN `academyLocationId` BIGINT(20) NOT NULL AFTER `application_program_id`,
  ADD COLUMN `batchId` BIGINT(20) NOT NULL AFTER `academyLocationId`,
  ADD COLUMN `programId` BIGINT(20) NOT NULL AFTER `batchId`,
  ADD COLUMN `programBatchSeatConfigId` BIGINT(20) NOT NULL AFTER `programId`,
  CHANGE `programBatchPeriodConfigId` `programBatchPeriodConfigId` BIGINT(20) NULL  AFTER `programBatchSeatConfigId`,
  ADD COLUMN `studentId` BIGINT(20) NOT NULL AFTER `programBatchPeriodConfigId`,
  CHANGE `lastUpdatedBy` `lastUpdatedBy` BIGINT(20) NOT NULL  AFTER `admissionDate`,
  ADD CONSTRAINT `fk_applicationAdmissionId` FOREIGN KEY (`applicationAdmissionId`) REFERENCES `applicationadmissiondetail`(`id`),
  ADD CONSTRAINT `fk_academyLocation` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`),
  ADD CONSTRAINT `fk_student` FOREIGN KEY (`studentId`) REFERENCES `students`(`personId`),
  ADD CONSTRAINT `fk_batch` FOREIGN KEY (`batchId`) REFERENCES `batches`(`id`),
  ADD CONSTRAINT `fk_program` FOREIGN KEY (`programId`) REFERENCES `programs`(`id`);
  
  ALTER TABLE `admission` 
  CHANGE `application_program_id` `application_program_id` BIGINT(20) NOT NULL, 
  CHANGE `code` `code` VARCHAR(20) NOT NULL;
  
  SET FOREIGN_KEY_CHECKS=1;
