set foreign_key_checks=0;

DROP TABLE  IF EXISTS `structure_leaf_node` ;
CREATE TABLE `structure_leaf_node` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `structureLevelThreeId` bigint(20) DEFAULT NULL,
  `questionSubPartName` varchar(45) DEFAULT NULL,
  `marks` double(10,2) DEFAULT NULL,
  `instructionQuestionSubPart` text,
  `negativeMarks` double(10,2) DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `whetherCompulsory` bit(1) DEFAULT NULL,
  `status` bit(1) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refstructure_level_three1174` (`structureLevelThreeId`),
  KEY `Refusers1436` (`lastUpdatedBy`),
  CONSTRAINT `Refstructure_level_three1174` FOREIGN KEY (`structureLevelThreeId`) REFERENCES `structure_level_three` (`id`),
  CONSTRAINT `Refusers1436` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS `structure_level_three`  ;
CREATE TABLE `structure_level_three` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `structureLevelTwoId` bigint(20) DEFAULT NULL,
  `questionPartName` varchar(45) DEFAULT NULL,
  `totalSubPart` int(11) DEFAULT NULL,
  `marks` double(10,2) DEFAULT NULL,
  `totalQuestionSubPartTobeAnswered` int(11) DEFAULT NULL,
  `totalMarksTobeAnswered` double(10,2) DEFAULT NULL,
  `instructionQuestionPart` text,
  `negativeMarks` double(10,2) DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `whetherCompulsory` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refstructure_level_two654` (`structureLevelTwoId`),
  KEY `Refusers1438` (`lastUpdatedBy`),
  CONSTRAINT `Refstructure_level_two654` FOREIGN KEY (`structureLevelTwoId`) REFERENCES `structure_level_two` (`id`),
  CONSTRAINT `Refusers1438` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS `structure_level_two`  ;
CREATE TABLE `structure_level_two` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `structureLevelOneId` bigint(20) DEFAULT NULL,
  `questionNumber` varchar(45) DEFAULT NULL,
  `totalParts` int(11) DEFAULT NULL,
  `marks` double(10,2) DEFAULT NULL,
  `totalQuestionPartTobeAnswered` int(11) DEFAULT NULL,
  `totalMarksTobeanswered` double(10,2) DEFAULT NULL,
  `negativeMarks` double(10,2) DEFAULT NULL,
  `instructionQuestion` varchar(255) DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `whetherCompulsory` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refstructure_level_one653` (`structureLevelOneId`),
  KEY `Refusers1439` (`lastUpdatedBy`),
  CONSTRAINT `Refstructure_level_one653` FOREIGN KEY (`structureLevelOneId`) REFERENCES `structure_level_one` (`id`),
  CONSTRAINT `Refusers1439` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS `structure_level_one` ;
CREATE TABLE `structure_level_one` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `questionPaperStructId` bigint(20) DEFAULT NULL,
  `optionGroupName` varchar(45) DEFAULT NULL,
  `totalQuestion` int(11) DEFAULT NULL,
  `optionGroupMarks` double(10,2) DEFAULT NULL,
  `totalQuestionTobeAnswered` int(11) DEFAULT NULL,
  `totalMarksTobeanswered` double(10,2) DEFAULT NULL,
  `instructionOptionGroup` text,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refquestion_paper_structure652` (`questionPaperStructId`),
  KEY `Refusers1437` (`lastUpdatedBy`),
  CONSTRAINT `Refquestion_paper_structure652` FOREIGN KEY (`questionPaperStructId`) REFERENCES `question_paper_structure` (`id`),
  CONSTRAINT `Refusers1437` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE  IF EXISTS `question_paper_structure` ;


set foreign_key_checks=1;

