ALTER TABLE `users`
	DROP COLUMN `userGroupId`,
	DROP COLUMN `salutationId`,
	DROP COLUMN `nameToBePrinted`,
	DROP COLUMN `emailId`,
	DROP COLUMN `status`,
	DROP COLUMN `whetherInternal`,
	DROP COLUMN `calendarId`,
	DROP COLUMN `departmentId`,
	DROP COLUMN `subDepartmentId`,
	DROP FOREIGN KEY `Refuser_groups1121`,
	DROP FOREIGN KEY `Refsalutations1091`,
	DROP FOREIGN KEY `Refdepartment1094`,
	DROP FOREIGN KEY `Refdepartment1093`,
	DROP FOREIGN KEY `Refcalendars1092`;

ALTER TABLE `users`
	ADD COLUMN `calendarId` BIGINT(20) NULL DEFAULT NULL AFTER `shortName`,
	ADD INDEX `fk_users_calendar` (`calendarId`),
	ADD CONSTRAINT `fk_users_calendar` FOREIGN KEY (`calendarId`) REFERENCES `calendars` (`id`);
	
ALTER TABLE `users`
	ADD COLUMN `status` BIT NOT NULL AFTER `lockedOn`;
	
	
ALTER TABLE `students`
	ALTER `userId` DROP DEFAULT;
	
ALTER TABLE `students`
	CHANGE COLUMN `userId` `userId` BIGINT(20) NOT NULL FIRST,
	DROP PRIMARY KEY,
	DROP INDEX `Refusers2126`,
	ADD PRIMARY KEY (`userId`),
	ADD INDEX `fk_students_users` (`userId`),
	ADD INDEX `fk_students_persons` (`personId`),
	DROP FOREIGN KEY `Refusers2126`,
	DROP FOREIGN KEY `Refpersons2127`,
	ADD CONSTRAINT `fk_students_users` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
	ADD CONSTRAINT `fk_students_persons` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`);
	
ALTER TABLE `students`
	DROP COLUMN `studentCode`;
	
	
CREATE TABLE `staffs` (
	`userId` BIGINT(20) NOT NULL,
	`personId` BIGINT(20) NOT NULL,
	`departmentId` BIGINT(20) NOT NULL,
	`subDepartmentId` BIGINT(20) NOT NULL,
	PRIMARY KEY (`userId`),
	INDEX `fk_staffs_person` (`personId`),
	INDEX `fk_staffs_department` (`departmentId`),
	INDEX `fk_staffs_sub_department` (`subDepartmentId`),
	INDEX `fk_staffs_users` (`userId`),
	CONSTRAINT `fk_staffs_users` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
	CONSTRAINT `fk_staffs_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
	CONSTRAINT `fk_staffs_department` FOREIGN KEY (`departmentId`) REFERENCES `department` (`id`),
	CONSTRAINT `fk_staffs_sub_department` FOREIGN KEY (`subDepartmentId`) REFERENCES `department` (`id`)
);

ALTER TABLE `staffs`
	ADD COLUMN `userGroupId` BIGINT(20) NOT NULL AFTER `subDepartmentId`,
	ADD INDEX `fk_users_userGroup` (`userGroupId`),
	ADD CONSTRAINT `fk_users_userGroup` FOREIGN KEY (`userGroupId`) REFERENCES `user_groups` (`id`);
	
ALTER TABLE `staffs`
	ADD COLUMN `whetherFaculty` BIT NOT NULL AFTER `userGroupId`,
	ADD COLUMN `whetherIntenal` BIT NOT NULL AFTER `whetherFaculty`;
	
ALTER TABLE `persons`
	DROP COLUMN `status`;

ALTER TABLE `staffs`   
  CHANGE `subDepartmentId` `subDepartmentId` BIGINT(20) NULL;

ALTER TABLE `staffs` 
CHANGE `whetherIntenal` `whetherInternal` BIT(1) NOT NULL;

ALTER TABLE `persons`
	ALTER `whetherEmployeeOfOrganization` DROP DEFAULT;
ALTER TABLE `persons`
	CHANGE COLUMN `whetherEmployeeOfOrganization` `whetherEmployeeOfOrganization` BIT(1) NULL AFTER `nationalityId`;
  
UPDATE `users`
SET `status`=1;	