/*
SQLyog Community v11.01 (64 bit)
MySQL - 5.1.37-community : Database - academia_serosoft_database_saket
*********************************************************************
*/ 
/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*Table structure for table `question_options` */

DROP TABLE IF EXISTS `question_options`;

CREATE TABLE `question_options` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `questionOptions` VARCHAR(100) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `displayOrder` BIGINT(20) DEFAULT NULL,
  `questionId` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`questionId`) REFERENCES `questions` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=INNODB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Table structure for table `question_sections` */

DROP TABLE IF EXISTS `question_sections`;

CREATE TABLE `question_sections` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `lastUpdate` DATETIME NOT NULL,
  `instruction` VARCHAR(255) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  `sectionTitle` VARCHAR(50) DEFAULT NULL,
  `questionnaireId` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT  FOREIGN KEY (`questionnaireId`) REFERENCES `questionnaire` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=INNODB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Table structure for table `questionnaire` */

DROP TABLE IF EXISTS `questionnaire`;

CREATE TABLE `questionnaire` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `questionnaireName` VARCHAR(50) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `questionnaireCode` VARCHAR(255) DEFAULT NULL,
  `displayOrder` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=INNODB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Table structure for table `questions` */

DROP TABLE IF EXISTS `questions`;

CREATE TABLE `questions` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `lastUpdate` DATETIME NOT NULL,
  `questionCode` VARCHAR(255) DEFAULT NULL,
  `questionText` VARCHAR(255) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  `questionType` VARCHAR(50) DEFAULT NULL,
  `displayOrder` BIGINT(20) DEFAULT NULL,
  `questionSectionId` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT FOREIGN KEY (`questionSectionId`) REFERENCES `question_sections` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=INNODB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
