CREATE TABLE `lack_of_other_criteria`(  
  `evaluationPlanId` BIGINT(20),
  `evaluationSequenceDetailId` BIGINT(20),
  `courseId` BIGINT(20),
  `approvalSoughtFor` VARCHAR(255),
  `lackOfCriteriaReason` VARCHAR(255),
  `serviceRequestId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `version` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan`(`id`),
  FOREIGN KEY (`evaluationSequenceDetailId`) REFERENCES `eval_seq_detail`(`id`),
  FOREIGN KEY (`courseId`) REFERENCES `courses`(`id`),
  FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`),
  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);

CREATE TABLE `complaint_type_setting_status`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `complaintTypeSettingId` BIGINT(20) NOT NULL,
  `requestStatusId` BIGINT(20),
  `active` BIT(1) DEFAULT NULL,
  `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
  FOREIGN KEY (`complaintTypeSettingId`) REFERENCES `complaint_type_settings`(`id`),
  FOREIGN KEY (`requestStatusId`) REFERENCES `request_status`(`id`)
);


ALTER TABLE `service_request_setting_status`  
  ADD FOREIGN KEY (`serviceRequestSettingId`) REFERENCES `service_request_settings`(`id`),
  ADD FOREIGN KEY (`requestStatusId`) REFERENCES `request_status`(`id`);


