 DROP TABLE IF EXISTS app_selection_replacement;
DROP TABLE IF EXISTS applicant_doc_link;
DROP TABLE IF EXISTS applicant_documents;
DROP TABLE IF EXISTS applicant_person_training;
DROP TABLE IF EXISTS application_status;
DROP TABLE IF EXISTS camp_coverage_user;
DROP TABLE IF EXISTS faculties;
DROP TABLE IF EXISTS faculty_cheques;
DROP TABLE IF EXISTS person_training;
DROP TABLE IF EXISTS assignment_topics;
DROP TABLE IF EXISTS assignment;
DROP TABLE IF EXISTS program_batch;
DROP TABLE IF EXISTS individual_hw_download;
DROP TABLE IF EXISTS individual_hw_upload;
DROP TABLE IF EXISTS individual_hw_assignment;

  ALTER TABLE `subject_mark_to_be_changed`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  
  ALTER TABLE `grade_type`   
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `exam_leave_request_details`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `evaluation_group`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `document_rules`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `currency_exchange_rate_history`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  
  ALTER TABLE `course_coverage_resource_booking`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `course_coverage_plan`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  

  ALTER TABLE `config_control_head_plan`   
  CHANGE `lastUpdateBy` `lastUpdatedBy` BIGINT(20) NOT NULL,
  DROP FOREIGN KEY `Refusers1340`,
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `application_references`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `application_payment_details`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `admission_status`   
  CHANGE `lastUpdated` `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  NOT NULL,
  ADD COLUMN `version` BIGINT(20) NOT NULL AFTER `lastUpdate`;

  ALTER TABLE `applicant_person`  
  ADD FOREIGN KEY (`casteCategoryId`) REFERENCES `caste_categories`(`id`);
 

ALTER TABLE `admission`  
ADD FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config`(`id`);

ALTER TABLE `bank_details`   
  CHANGE `lastUpdatedby` `lastUpdatedBy` BIGINT(20) NOT NULL, 
  DROP INDEX `Refusers2155`,
  DROP FOREIGN KEY `Refusers2155`,
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  
  ALTER TABLE `application` DROP FOREIGN KEY `Refstudents2389`;
ALTER TABLE `application`   DROP INDEX `Refstudents2389`;
ALTER TABLE `application` ADD CONSTRAINT `Refstudents2389` FOREIGN KEY (`existingStudentId`) REFERENCES `students`(`userId`);


ALTER TABLE `application_prog_stage_status`  
  ADD FOREIGN KEY (`approvedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `application_program`  
  ADD FOREIGN KEY (`withdrawl_reason_id`) REFERENCES `application_prog_withdraw_reasons`(`id`),
  ADD FOREIGN KEY (`rejection_reason_id`) REFERENCES `application_prog_rejection_reasons`(`id`),
  ADD FOREIGN KEY (`approval_reason_id`) REFERENCES `application_prog_approval_reasons`(`id`);
  
  ALTER TABLE `batch_documents`  
  ADD FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`);

  ALTER TABLE `bill_fee_plan_rule_stage`   
  DROP INDEX `Refuser67645_idx`,
  DROP FOREIGN KEY `Refstudent6665`,
  ADD FOREIGN KEY (`studentId`) REFERENCES `users`(`id`),
  ADD FOREIGN KEY (`installmentRef`) REFERENCES `installment_details`(`id`);

  ALTER TABLE `bill_header` DROP FOREIGN KEY `Refuser4986`;
ALTER TABLE `bill_header` ADD CONSTRAINT `Refuser4986` FOREIGN KEY (`userId`) REFERENCES `staffs`(`userId`) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE `bill_students_covered` DROP FOREIGN KEY `Refstudents2130`;
ALTER TABLE `bill_students_covered` ADD CONSTRAINT `Refstudents2130` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `completion_certificates`  
  ADD FOREIGN KEY (`certificateId`) REFERENCES `certificates`(`id`);

  ALTER TABLE `completions` DROP FOREIGN KEY `FK_c_students_studentId`;
ALTER TABLE `completions` ADD CONSTRAINT `FK_c_students_studentId` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `course_documents`  
  ADD FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`);



  ALTER TABLE `course_topic_documents`  
  ADD FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`);

  ALTER TABLE `data_to_be_changed`  
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `eval_seq_detail`  
  ADD FOREIGN KEY (`approvedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `evaluation_group_applicant_document` DROP FOREIGN KEY `RefDocumentId`;
  ALTER TABLE `evaluation_group_applicant_document`     DROP INDEX `RefDocumentId_idx`;
ALTER TABLE `evaluation_group_applicant_document` ADD CONSTRAINT `RefDocumentId` FOREIGN KEY (`documentId`) REFERENCES `extended_documents`(`documentId`) ON UPDATE NO ACTION ON DELETE NO ACTION;

  ALTER TABLE `evaluation_plan_rank`   
  ADD COLUMN `effectiveMarks` DOUBLE(20,2) NULL AFTER `status`;

  ALTER TABLE `evaluation_type_course`  
  ADD FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants`(`id`);


  ALTER TABLE `examination_request`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `fee_plan_documents`  
  ADD FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`);

  ALTER TABLE `fee_request` DROP FOREIGN KEY `Refstudents2131`;
ALTER TABLE `fee_request` ADD CONSTRAINT `Refstudents2131` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `fee_schedule_student` DROP FOREIGN KEY `Refstudents2132`;
ALTER TABLE `fee_schedule_student` ADD CONSTRAINT `Refstudents2132` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

  ALTER TABLE `free_format_request`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `fine_request_details`   
  ADD COLUMN `serviceRequestId` BIGINT(20) NOT NULL AFTER `lastUpdatedBy`,
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

ALTER TABLE `kys_data` DROP FOREIGN KEY `Refstudents232`;
ALTER TABLE `kys_data` ADD CONSTRAINT `Refstudents232` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE `leave_request`  
  ADD FOREIGN KEY (`requestId`) REFERENCES `service_requests`(`id`),
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `payment_header` DROP FOREIGN KEY `Refuser6541`;
ALTER TABLE `payment_header` ADD CONSTRAINT `Refuser6541` FOREIGN KEY (`userId`) REFERENCES `staffs`(`userId`) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE `person_relationships`  
  ADD FOREIGN KEY (`relatedPersonId`) REFERENCES `persons`(`id`);

  ALTER TABLE `persons`   
  DROP FOREIGN KEY `Refsalutations2151`,
   DROP INDEX `Refsalutations2151`,
  DROP INDEX `bankDetailId`,
  DROP FOREIGN KEY `persons_ibfk_1`,
  ADD FOREIGN KEY (`salutationId`) REFERENCES `salutations`(`id`),
  ADD FOREIGN KEY (`castCategoryId`) REFERENCES `caste_categories`(`id`),
  ADD FOREIGN KEY (`bankDetailId`) REFERENCES `bank_details`(`id`);
 
  ALTER TABLE `program_course_section_req`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `program_slctn_process_status`   
  CHANGE `lastUpdated` `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  NOT NULL;

ALTER TABLE `receipt_header` DROP FOREIGN KEY `Refuser87`;
ALTER TABLE `receipt_header` ADD CONSTRAINT `Refuser87` FOREIGN KEY (`userId`) REFERENCES `staffs`(`userId`) ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE `req_against_bill_details`  
  ADD FOREIGN KEY (`feeRelatedRequestDetailId`) REFERENCES `fee_related_request_details`(`id`);

  ALTER TABLE `req_against_feehead_details`  
  ADD FOREIGN KEY (`feeRelatedRequestDetailId`) REFERENCES `fee_related_request_details`(`id`);

  ALTER TABLE `req_documents_submitted`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `request_followup`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`);

  ALTER TABLE `reservation_category`   
  DROP INDEX `Refaddress_type333`,
  DROP FOREIGN KEY `Refaddress_type333`,
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `resource_booking_adhocs`   
  DROP INDEX `Refusers583`,
  DROP FOREIGN KEY `Refusers583`,
  ADD FOREIGN KEY (`internalUser`) REFERENCES `staffs`(`userId`);

  ALTER TABLE `resource_booking_users` DROP FOREIGN KEY `Refusers80`;
ALTER TABLE `resource_booking_users` ADD CONSTRAINT `Refusers80` FOREIGN KEY (`userId`) REFERENCES `staffs`(`userId`);

ALTER TABLE `resource_bookings` DROP FOREIGN KEY `Refusers1010`;
ALTER TABLE `resource_bookings` ADD CONSTRAINT `Refusers1010` FOREIGN KEY (`approvedBy`) REFERENCES `staffs`(`userId`);
ALTER TABLE `resource_bookings` DROP FOREIGN KEY `Refusers1011`;
ALTER TABLE `resource_bookings` ADD CONSTRAINT `Refusers1011` FOREIGN KEY (`bookedBy`) REFERENCES `staffs`(`userId`);

  ALTER TABLE `scholarship_awardees` DROP FOREIGN KEY `Refstudents2135`;
ALTER TABLE `scholarship_awardees` ADD CONSTRAINT `Refstudents2135` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

  ALTER TABLE `sponsorship_awardees` DROP FOREIGN KEY `Refstudents2150`;
ALTER TABLE `sponsorship_awardees` ADD CONSTRAINT `Refstudents2150` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

  ALTER TABLE `stu_account_receipts` DROP FOREIGN KEY `Refstudents2140`;
ALTER TABLE `stu_account_receipts` ADD CONSTRAINT `Refstudents2140` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `student_cert_request`  
  ADD FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`),
  ADD FOREIGN KEY (`certificateId`) REFERENCES `certificates`(`id`);

  ALTER TABLE `student_distribution_list`  
  ADD FOREIGN KEY (`handoverTo`) REFERENCES `users`(`id`);

  ALTER TABLE `student_documents` DROP FOREIGN KEY `FK_student_documents_students`;
ALTER TABLE `student_documents` ADD CONSTRAINT `FK_student_documents_students` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);


ALTER TABLE `student_exam_subject` DROP FOREIGN KEY `Refstudents2149`;
ALTER TABLE `student_exam_subject` ADD CONSTRAINT `Refstudents2149` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `student_exam` DROP FOREIGN KEY `Refapplication_form436`;
ALTER TABLE `student_exam` ADD CONSTRAINT `Refapplication_form436` FOREIGN KEY (`applicationId`) REFERENCES `application`(`id`);

ALTER TABLE `student_feedback` DROP FOREIGN KEY `Refstudents2145`;
ALTER TABLE `student_feedback` ADD CONSTRAINT `Refstudents2145` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);
ALTER TABLE `student_feedback` DROP FOREIGN KEY `Refstudents2148`;
ALTER TABLE `student_feedback` ADD CONSTRAINT `Refstudents2148` FOREIGN KEY (`feedbackGivenBy`) REFERENCES `students`(`userId`);

ALTER TABLE `student_stakeholders` DROP FOREIGN KEY `Refapplication_form433`;
ALTER TABLE `student_stakeholders` ADD CONSTRAINT `Refapplication_form433` FOREIGN KEY (`applicationId`) REFERENCES `application`(`id`);
ALTER TABLE `student_stakeholders` DROP FOREIGN KEY `Refstudents2141`;
ALTER TABLE `student_stakeholders` ADD CONSTRAINT `Refstudents2141` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);
 
ALTER TABLE `student_trans_terminate` DROP FOREIGN KEY `Refstudents2138`;
ALTER TABLE `student_trans_terminate` ADD CONSTRAINT `Refstudents2138` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`);

ALTER TABLE `survey_distribution_list`   
  ADD COLUMN `studentId` BIGINT(20) NULL AFTER `lastUpdate`,
  ADD FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`),
  ADD FOREIGN KEY (`facultyId`) REFERENCES `staffs`(`userId`);

  ALTER TABLE `temp_emp_leave`  
  ADD FOREIGN KEY (`userId`) REFERENCES `users`(`id`),
  ADD FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

  ALTER TABLE `temp_terminations` DROP FOREIGN KEY `temp_terminations_ibfk_1`;
ALTER TABLE `temp_terminations` ADD CONSTRAINT `temp_terminations_ibfk_1` FOREIGN KEY (`reasonId`) REFERENCES `termination_reasons`(`id`);

ALTER TABLE `user_academy_locations`  
  ADD FOREIGN KEY (`userId`) REFERENCES `users`(`id`);
  