CREATE TABLE `report_type`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `typeName` VARCHAR(100) NOT NULL,
  PRIMARY KEY (`id`)
);

CREATE TABLE  `report_template`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `reportTypeId` BIGINT(20),
  `templateCode` VARCHAR(100),
  `templateName` VARCHAR(100),
  `imageLocation` VARCHAR(255),
  `jasperFileLocation` VARCHAR(255),
  `documentTypes` VARCHAR(100),
  `whetherDefault` BOOLEAN,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_reportType` FOREIGN KEY (`reportTypeId`) REFERENCES  `report_type`(`id`)
);

CREATE TABLE  `report_template_configuration`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20),
  `reportTemplateId` BIGINT(20),
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_cad_location` FOREIGN KEY (`academyLocationId`) REFERENCES  `academy_location`(`id`),
  CONSTRAINT `fk_report_template` FOREIGN KEY (`reportTemplateId`) REFERENCES  `report_template`(`id`),
  CONSTRAINT `Reffkusers` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

