/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.hsql;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.Table;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.SQLException;

public class HsqlTable
extends Table {
    private static final Log LOG = LogFactory.getLog(HsqlDbSupport.class);
    private boolean version18;

    public HsqlTable(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name) {
        super(jdbcTemplate, dbSupport, schema, name);
        try {
            int majorVersion = jdbcTemplate.getMetaData().getDatabaseMajorVersion();
            this.version18 = majorVersion < 2;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine the Hsql version", e);
        }
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + this.dbSupport.quote(this.schema.getName(), this.name) + " CASCADE", new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected boolean doExistsNoQuotes() throws SQLException {
        return this.exists(null, this.dbSupport.getSchema(this.schema.getName().toUpperCase()), this.name.toUpperCase(), new String[0]);
    }

    protected void doLock() throws SQLException {
        if (this.version18) {
            LOG.debug("Unable to lock " + this + " as Hsql 1.8 does not support locking. No concurrent migration supported.");
        } else {
            this.jdbcTemplate.execute("LOCK TABLE " + this + " WRITE", new Object[0]);
        }
    }
}

