/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.CriteriaBuilderConfigurer.DBProperties;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.CriteriaBuilderConfigurer.SavedSearchConfigurationApp;
import in.serosoft.CriteriaBuilderConfigurer.ViewDefinitionConfigurationApp;
import in.serosoft.cb.MetadataFiller.Dao;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableColumnCustomCategory;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.model.CustomField;
import in.serosoft.cb.model.SearchConfigDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.service.SearchTableColumnCustomCategoryService;
import in.serosoft.cb.service.SearchTableColumnService;
import in.serosoft.cb.service.SearchTableService;
import in.serosoft.cb.util.threadPool.ThreadPool;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class DataConfigurerApp {
    static Path dbSavedSearchPath;

    public static void main(String[] args) throws Exception {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        DBProperties dbProperties = appContext.getBean(DBProperties.class);
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        DataConfigurerApp.preConfigure();
        Dao cbdb = new Dao(dbProperties);
        cbdb.updateTableDetails();
        List<String> nonExecutedViewDefinitionXmls = ViewDefinitionConfigurationApp.inserViewDefinitions(searchConfiguratonService);
        List<Path> listofFiles = DataConfigurerApp.readFileNames();
        List<SearchTable> searchTables = searchConfiguratonService.findAllSearchTables();
        Map searchTablesMap = searchTables.stream().collect(Collectors.toMap(SearchTable::getDbTableName, Function.identity(), (oldValue, newValue) -> newValue));
        List<SearchTableRelation> searchTableRelations = searchConfiguratonService.findAllSearchTableRelations();
        ArrayList<String> nonExecutedXmls = new ArrayList<String>();
        ExecutorService executor = ThreadPool.getExecutor();
        List futures = listofFiles.parallelStream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".xml")).map(file -> CompletableFuture.supplyAsync(() -> {
            try {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                SearchConfigDTO searchConfigDTO = ConfigurationReader.readXmlFile(inputStream);
                return searchConfiguratonService.configureAll(searchConfigDTO, searchTablesMap, searchTableRelations);
            }
            catch (Exception e) {
                e.printStackTrace();
                nonExecutedXmls.add(file.getFileName().toString());
                return null;
            }
        }, executor)).collect(Collectors.toList());
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List searchConfigs = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
        for (SearchConfig searchConfig : searchConfigs) {
            try {
                searchConfiguratonService.createSearchConfig(searchConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                nonExecutedXmls.add("issue on create- " + searchConfig.getConfigCode());
            }
        }
        DataConfigurerApp.updateStandardMasterFields(searchConfiguratonService);
        DataConfigurerApp.postConfigure();
        System.out.println("Disable sorting START- " + new Date());
        searchConfiguratonService.disableSortingForAggregateColumns();
        System.out.println(" END- " + new Date());
        DataConfigurerApp.updateCustomFields(searchConfiguratonService, appContext);
        System.out.println("########## ERROR VIEW DEFINITION XML FILES ##########");
        nonExecutedViewDefinitionXmls.forEach(System.out::println);
        System.out.println("########## ERROR CB XML FILES ##########");
        nonExecutedXmls.forEach(System.out::println);
        try {
            DataConfigurerApp.updateSearchTableCustomCategory(appContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("End data config END- " + new Date());
        ((ConfigurableApplicationContext)appContext).close();
    }

    private static void updateStandardMasterFields(SearchConfiguratonService searchConfiguratonService) {
        searchConfiguratonService.updateStandardMasterColumns();
    }

    private static void updateCustomFields(SearchConfiguratonService searchConfiguratonService, ApplicationContext appContext) {
        SearchTableColumnService searchTableColumnService = appContext.getBean(SearchTableColumnService.class);
        List<CustomField> customFields = searchConfiguratonService.findAllCustomFields();
        customFields.forEach(customField -> {
            if (customField.getWhetherStandardMaster().booleanValue()) {
                customField.setWhetherSimpleCatagory(false);
            } else if (customField.getWhetherSimpleCatagory().booleanValue()) {
                customField.setTableColumnReff("categories_info#subCategoryName");
            } else {
                customField.setTableColumnReff(null);
                customField.setCustomFieldConfigId(null);
            }
            searchTableColumnService.updateCBCustomField((CustomField)customField);
        });
    }

    private static List<Path> readFileNames() throws IOException {
        Path idGeneratorXMLfolderPath = PropertiesFileManager.getSourceDirPath("XMLParser/idGeneratorXML");
        Path cbxmlPath = PropertiesFileManager.getSourceDirPath("XMLParser/cbxml");
        Path reportXMLPath = PropertiesFileManager.getSourceDirPath("XMLParser/reportXML");
        Path msgxmlPath = PropertiesFileManager.getSourceDirPath("XMLParser/msgxml");
        List<Path> listOfPaths = Stream.of(idGeneratorXMLfolderPath, cbxmlPath, reportXMLPath, msgxmlPath).filter(Objects::nonNull).flatMap(path -> {
            try {
                return Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        System.out.println("listofFiles:" + listOfPaths.size());
        return listOfPaths;
    }

    private static void postConfigure() {
        Path savedSearchesPath = PropertiesFileManager.getSourceDirPath("XMLParser/savedSearches");
        if (savedSearchesPath != null) {
            int batchSize = 10;
            try {
                List fileList = Files.walk(dbSavedSearchPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                List batches = Stream.iterate(0, i -> i + batchSize).limit((fileList.size() + batchSize - 1) / batchSize).map(i -> fileList.subList((int)i, Math.min(i + batchSize, fileList.size()))).collect(Collectors.toList());
                int remainingCounter = batches.size();
                for (List list : batches) {
                    System.out.println(new Date() + " Saved search restore batch of: " + batchSize + " remaining count: " + remainingCounter--);
                    SavedSearchConfigurationApp.restore(list);
                }
                SavedSearchConfigurationApp.restoreDefault(savedSearchesPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Saved search restored.");
        } else {
            System.out.println("Invalid file path for saved searches.");
        }
    }

    private static void preConfigure() throws IOException {
        String parent = PropertiesFileManager.OUTPUT_DIRECTORY;
        dbSavedSearchPath = DataConfigurerApp.createDir(parent, "XMLParser", "savedSearches");
        System.out.println("saved Search Backup path: " + dbSavedSearchPath);
        SavedSearchConfigurationApp.backup(dbSavedSearchPath);
    }

    public static Path createDir(String parent, String ... subDirectoryName) {
        Path subDirectoryPath = Paths.get(parent, subDirectoryName);
        try {
            Path createdSubDirectoryPath = Files.exists(subDirectoryPath, new LinkOption[0]) ? subDirectoryPath : Files.createDirectories(subDirectoryPath, new FileAttribute[0]);
            return createdSubDirectoryPath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void updateSearchTableCustomCategory(ApplicationContext appContext) {
        SearchTableColumnCustomCategoryService categoryService = appContext.getBean(SearchTableColumnCustomCategoryService.class);
        SearchTableService searchTableService = appContext.getBean(SearchTableService.class);
        SearchTableColumnService searchTableColumnService = appContext.getBean(SearchTableColumnService.class);
        Long searchTableId = searchTableService.findSearchTableIdByTableName("person_cd");
        List<SearchTableColumnCustomCategory> searchTableColumnCustomCategories = categoryService.findAllUserTypeCategory();
        if (searchTableId != null) {
            List<SearchTableColumn> searchTableColumns = searchTableColumnService.findColumnBySearchTableId(searchTableId);
            Map ColNameAndSearchTableColumn = searchTableColumns.stream().collect(Collectors.toMap(SearchTableColumn::getColumnName, Function.identity(), (oldValue, newValue) -> newValue));
            for (SearchTableColumnCustomCategory sCustomCategory : searchTableColumnCustomCategories) {
                if (!ColNameAndSearchTableColumn.containsKey(sCustomCategory.getColumnName())) continue;
                sCustomCategory.setSearchTableColumnId(((SearchTableColumn)ColNameAndSearchTableColumn.get(sCustomCategory.getColumnName())).getId());
                sCustomCategory.setSearchTable(((SearchTableColumn)ColNameAndSearchTableColumn.get(sCustomCategory.getColumnName())).getSearchTable());
                categoryService.updateCustomCategory(sCustomCategory);
            }
        }
    }
}

