/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import in.serosoft.cb.xmlParser.DBSchemaReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SearchResultViewConfigurationApp {
    public static void main(String[] args) throws IOException {
        String resourcePath = Paths.get(System.getenv("ACADEMIA_PROPERTIES"), new String[0]) + "/XMLParser/searchResultViews";
        Path searchPath = Paths.get(resourcePath, new String[0]);
        SearchResultViewConfigurationApp.backup(searchPath);
        SearchResultViewConfigurationApp.restore(searchPath);
    }

    public static void backup(Path path) throws IOException {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        List<SearchResultViewDTO> searchResultViewDTOs = searchConfiguratonService.readSearchResultViews();
        for (SearchResultViewDTO searchResultViewDTO : searchResultViewDTOs) {
            Path filePath = path.resolve(searchResultViewDTO.getViewCode() + ".xml");
            String resourcePath = Paths.get(System.getenv("ACADEMIA_PROPERTIES"), new String[0]) + "/XMLParser/searchResultViews/" + searchResultViewDTO.getViewCode() + ".xml";
            if (Files.deleteIfExists(Paths.get(resourcePath, new String[0]))) {
                Files.createDirectories(path, new FileAttribute[0]);
                Files.createFile(Paths.get(resourcePath, new String[0]), new FileAttribute[0]).toFile().mkdirs();
            } else {
                Files.createDirectories(path, new FileAttribute[0]);
                Paths.get(resourcePath, new String[0]).toFile();
            }
            DBSchemaReader.readSchemaToWriteXmlFile(searchResultViewDTO, Files.newOutputStream(Paths.get(resourcePath, new String[0]), new OpenOption[0]));
        }
        ((ConfigurableApplicationContext)appContext).close();
    }

    public static void restore(Path filepath) throws IOException {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        ArrayList<SearchResultViewDTO> searchResultViewDTOs = new ArrayList<SearchResultViewDTO>();
        Files.walk(filepath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".xml")).forEach(file -> {
            block6: {
                try {
                    InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                    if (inputStream == null) break block6;
                    try {
                        SearchResultViewDTO searchResultViewDTO = ConfigurationReader.readSearchResultViewsXmlFile(inputStream);
                        searchResultViewDTOs.add(searchResultViewDTO);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        searchConfiguratonService.updateSearchResultViews(searchResultViewDTOs);
        ((ConfigurableApplicationContext)appContext).close();
    }
}

