/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ServerPropertiesFileGenerator {
    private static final String SYSTEM_ENV_KEY = "ACADEMIA_PROPERTIES";

    public static void main(String[] args) throws IOException {
        String webappsFolder = Paths.get(System.getenv(SYSTEM_ENV_KEY), new String[0]).resolveSibling("webapps").toAbsolutePath().toString();
        Files.walk(Paths.get(webappsFolder, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".jar")).filter(path -> path.toString().contains("serosoft-")).forEach(jarFile -> ServerPropertiesFileGenerator.copyPropertiesFilesFromJar(jarFile.toString(), System.getenv(SYSTEM_ENV_KEY)));
        System.out.println("Properties files copied to: " + System.getenv(SYSTEM_ENV_KEY));
    }

    private static void copyPropertiesFilesFromJar(String jarFile, String outputFolder) {
        try (ZipFile zip = new ZipFile(jarFile);){
            zip.stream().filter(entry -> entry.getName().endsWith(".properties")).filter(entry -> !entry.getName().endsWith("/pom.properties")).forEach(entry -> {
                String entryName = Paths.get(entry.getName(), new String[0]).getFileName().toString();
                try (InputStream inputStream = zip.getInputStream((ZipEntry)entry);
                     ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, length);
                    }
                    Properties newProperties = new Properties();
                    newProperties.load(new ByteArrayInputStream(outputStream.toByteArray()));
                    File outputFile = new File(outputFolder, entryName);
                    Properties existingProperties = new Properties();
                    if (outputFile.exists()) {
                        existingProperties.load(new FileReader(outputFile));
                    }
                    newProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> existingProperties.putIfAbsent(key, value)));
                    existingProperties.store(new FileWriter(outputFile), null);
                    System.out.println("Copied properties file: " + jarFile + entry.toString());
                }
                catch (IOException e) {
                    System.out.println("Error while copying properties file: " + jarFile + entry.toString());
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            System.out.println("Unable to read jar file: " + jarFile);
            e.printStackTrace();
        }
    }
}

