/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.dao.impl;

import in.serosoft.cb.dao.CBGenericDAO;
import in.serosoft.cb.exception.CriteriaBuilderException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;

public class CBGenericDAOImpl<E, PK extends Serializable>
implements CBGenericDAO<E, PK> {
    private static final Logger feesAndToolEventLogger = LogManager.getLogger("FeesAndToolEventLogger");
    protected SessionFactory sessionFactory;
    private final Class<? extends E> _entityClass;

    public CBGenericDAOImpl(Class<? extends E> entityClass) {
        this._entityClass = entityClass;
    }

    protected Session getCrntSession() throws CriteriaBuilderException {
        try {
            return this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException e) {
            feesAndToolEventLogger.error("Parse Exception : {} ", (Throwable)e);
            throw new CriteriaBuilderException("Failed to get thread session ", e);
        }
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public PK create(E newInstance) throws CriteriaBuilderException {
        Serializable id = null;
        Session session = this.getCrntSession();
        try {
            id = session.save(newInstance);
            this.getCrntSession().flush();
        }
        catch (HibernateException e) {
            feesAndToolEventLogger.error("Parse Exception : {} ", (Throwable)e);
            throw new CriteriaBuilderException("Failed to insert  " + newInstance, e);
        }
        return (PK)id;
    }

    @Override
    public void createAll(List<E> list) {
        Session session = this.getCrntSession();
        try {
            for (E newInstance : list) {
                session.save(newInstance);
            }
            session.flush();
        }
        catch (HibernateException e) {
            feesAndToolEventLogger.error("Parse Exception : {} ", (Throwable)e);
        }
    }

    @Override
    public void update(E entity) throws CriteriaBuilderException {
        try {
            this.getCrntSession().merge(entity);
            this.getCrntSession().flush();
        }
        catch (HibernateException e) {
            feesAndToolEventLogger.error("Parse Exception : {} ", (Throwable)e);
            throw new CriteriaBuilderException("Exception while updating entity ", e);
        }
    }

    @Override
    public void merge(E entity) throws CriteriaBuilderException {
        try {
            this.getCrntSession().merge(entity);
            this.getCrntSession().flush();
        }
        catch (ConstraintViolationException e) {
            throw new CriteriaBuilderException(e.getMessage());
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while updating entity ", e);
        }
    }

    @Override
    public E get(PK id) throws CriteriaBuilderException {
        try {
            return (E)this.getCrntSession().get(this._entityClass, (Serializable)id);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while getting entity ", e);
        }
    }

    @Override
    public E load(PK id) throws CriteriaBuilderException {
        try {
            return (E)this.getCrntSession().load(this._entityClass, (Serializable)id);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while loading entity ", e);
        }
    }

    @Override
    public Criteria getCriteria() throws CriteriaBuilderException {
        try {
            return this.getCrntSession().createCriteria(this._entityClass);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while creating criteria ", e);
        }
    }

    @Override
    public Criteria getCriteria(Class entityclass) throws CriteriaBuilderException {
        try {
            return this.getCrntSession().createCriteria(entityclass);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while getting criteria ", e);
        }
    }

    @Override
    public <V> List<V> executeCriteria(Criteria criteria) throws CriteriaBuilderException {
        try {
            return criteria.list();
        }
        catch (HibernateException e) {
            feesAndToolEventLogger.error("Parse Exception : {} ", (Throwable)e);
            throw new CriteriaBuilderException("Exception while executing criteria " + criteria, e);
        }
    }

    @Override
    public <V> V loadObject(Class classs, PK id) throws CriteriaBuilderException {
        try {
            return (V)this.getCrntSession().load(classs, (Serializable)id);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while load entity ", e);
        }
    }

    @Override
    public <V> V getObject(Class classs, PK id) throws CriteriaBuilderException {
        try {
            return (V)this.getCrntSession().get(classs, (Serializable)id);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while get entity ", e);
        }
    }

    @Override
    public <V> V getEntityWithAssociations(Class entityClass, PK entityId, String ... entityAssociations) throws CriteriaBuilderException {
        V dataObject = null;
        Criteria criteria = this.getCriteria(entityClass);
        try {
            for (String associationName : entityAssociations) {
                criteria.createAlias(associationName, associationName, 1);
            }
            criteria.add(Restrictions.eq("id", entityId));
            List<V> entityList = this.executeCriteria(criteria);
            if (entityList.size() > 0) {
                dataObject = entityList.get(0);
            }
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while executing getEntityWithAssociations " + criteria, e);
        }
        return dataObject;
    }

    @Override
    public Query getQueryObject(String hql) throws CriteriaBuilderException {
        try {
            Query query = this.getCrntSession().createQuery(hql);
            return query;
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while creating query object " + hql, e);
        }
    }

    @Override
    public <V> List<V> executeHQLSelectQuery(Query query) throws CriteriaBuilderException {
        try {
            return query.list();
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while executing hq query  " + query, e);
        }
    }

    @Override
    public int executeHQLDMLQuery(Query query) throws CriteriaBuilderException {
        try {
            return query.executeUpdate();
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while executing hq query  " + query, e);
        }
    }

    @Override
    public PK saveEntity(Object newInstance) throws CriteriaBuilderException {
        Serializable id = null;
        Session session = this.getCrntSession();
        try {
            id = session.save(newInstance);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Failed to insert  " + newInstance + " successfully", e);
        }
        return (PK)id;
    }

    @Override
    public void updateEntity(Object newInstance) throws CriteriaBuilderException {
        try {
            this.getCrntSession().update(newInstance);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while refresh entity ", e);
        }
    }

    @Override
    public <E> List<E> findAll() throws CriteriaBuilderException {
        Criteria criteria = this.getCriteria(this._entityClass);
        List list = this.executeCriteria(criteria);
        return list;
    }

    @Override
    public void delete(E newInstance) throws CriteriaBuilderException {
        try {
            this.getCrntSession().delete(newInstance);
        }
        catch (HibernateException e) {
            throw new CriteriaBuilderException("Exception while deleting entity ", e);
        }
    }

    @Override
    public <T> T findById(Long id) {
        Criteria criteria = this.getCriteria(this._entityClass);
        criteria.add(Restrictions.eq("id", id));
        return (T)criteria.uniqueResult();
    }

    @Override
    public <E> List<E> findAll(List<Long> ids) {
        if (ids != null && ids.size() > 0) {
            Criteria criteria = this.getCriteria(this._entityClass);
            criteria.add(Restrictions.in("id", ids));
            return criteria.list();
        }
        return new ArrayList();
    }
}

