/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen;

import in.serosoft.licensegen.domain.Entitlement;
import in.serosoft.licensegen.service.LicenseGeneratorService;
import java.io.File;
import java.security.MessageDigest;
import java.security.Security;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseGenerator {
    private static final String PUBLIC_KEY_FILENNAME = "public.key";
    private static final String LICENSE_CONTENT_FILENAME = "serosoft_license.lic";
    @Autowired
    private LicenseGeneratorService licenseGeneratorService;

    public void generateLicense() throws Exception {
        Entitlement e = this.licenseGeneratorService.findEntitlement();
        String encryptedContent = this.encrypt(PUBLIC_KEY_FILENNAME, LICENSE_CONTENT_FILENAME);
        String md5HexContent = LicenseGenerator.getHexString(this.generateMD5Hash(encryptedContent));
        if (e == null) {
            e = new Entitlement();
            e.setInfo1(encryptedContent);
            e.setInfo2(md5HexContent);
            e.setInfo3(new Date());
            this.licenseGeneratorService.create(e);
        } else {
            e.setInfo1(encryptedContent);
            e.setInfo2(md5HexContent);
            e.setInfo3(new Date());
            this.licenseGeneratorService.update(e);
        }
    }

    private String encrypt(String publicKeyFilename, String inputFilename) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        String value = "";
        String key = FileUtils.readFileToString(new File(publicKeyFilename));
        AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(Base64.decode(key));
        PKCS1Encoding e = new PKCS1Encoding(new RSAEngine());
        e.init(true, publicKey);
        String inputdata = FileUtils.readFileToString(new File(inputFilename));
        byte[] messageBytes = inputdata.getBytes();
        int len = e.getInputBlockSize();
        for (int i = 0; i < messageBytes.length; i += e.getInputBlockSize()) {
            if (i + len > messageBytes.length) {
                len = messageBytes.length - i;
            }
            byte[] hexEncodedCipher = e.processBlock(messageBytes, i, len);
            value = value + LicenseGenerator.getHexString(hexEncodedCipher);
        }
        return value;
    }

    private byte[] generateMD5Hash(String stringContentToHash) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(stringContentToHash.getBytes());
        return md.digest();
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

