/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.ciphers;

import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class GenerateRSAKeys {
    public static void main(String[] args) {
        String publicKeyFilename = null;
        String privateKeyFilename = null;
        GenerateRSAKeys generateRSAKeys = new GenerateRSAKeys();
        if (args.length < 2) {
            System.err.println("Usage: java " + generateRSAKeys.getClass().getName() + " Public_Key_Filename Private_Key_Filename");
            System.exit(1);
        }
        publicKeyFilename = args[0].trim();
        privateKeyFilename = args[1].trim();
        generateRSAKeys.generate(publicKeyFilename, privateKeyFilename);
    }

    private void generate(String publicKeyFilename, String privateFilename) {
        try {
            Security.addProvider(new BouncyCastleProvider());
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
            SecureRandom random = GenerateRSAKeys.createFixedRandom();
            generator.initialize(1024, random);
            KeyPair pair = generator.generateKeyPair();
            PublicKey pubKey = pair.getPublic();
            PrivateKey privKey = pair.getPrivate();
            FileUtils.writeByteArrayToFile(new File(publicKeyFilename), Base64.encode(pubKey.getEncoded()));
            FileUtils.writeByteArrayToFile(new File(privateFilename), Base64.encode(privKey.getEncoded()));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static SecureRandom createFixedRandom() {
        return new FixedRand();
    }

    private static class FixedRand
    extends SecureRandom {
        MessageDigest sha;
        byte[] state;

        FixedRand() {
            try {
                this.sha = MessageDigest.getInstance("SHA-1");
                this.state = this.sha.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("can't find SHA-1!");
            }
        }

        @Override
        public void nextBytes(byte[] bytes) {
            this.sha.update(this.state);
            for (int off = 0; off < bytes.length; off += this.state.length) {
                this.state = this.sha.digest();
                if (bytes.length - off > this.state.length) {
                    System.arraycopy(this.state, 0, bytes, off, this.state.length);
                } else {
                    System.arraycopy(this.state, 0, bytes, off, bytes.length - off);
                }
                this.sha.update(this.state);
            }
        }
    }
}

