/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.translation.utility;

import in.serosoft.translation.utility.KeyValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.modeshape.common.text.Inflector;

public class LanguageTranslationUtility {
    public static String KEY = "AIzaSyCYeQSJpjRivyWQEdVL2Ol0Ea351rNsNGQ";
    public static final String SOURCE_FILE_PATH = "/opt/serosoft/v2_uploads/english/";
    public static final String DESTINATION_FILE_PATH = "/opt/serosoft/v2_uploads/converted/";
    public static String TARGET_LANGUAGE = "afr";

    public LanguageTranslationUtility(String targetLanguage) {
        TARGET_LANGUAGE = targetLanguage;
    }

    public String translator(String inputKey) throws Exception {
        String inputLine;
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        String url = "https://www.googleapis.com/language/translate/v2?key=" + KEY + "&source=en&target=" + URLEncoder.encode(TARGET_LANGUAGE, "UTF-8") + "&q=" + URLEncoder.encode(inputKey, "UTF-8");
        String jsonTxt = "";
        URL verisign = new URL(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(verisign.openStream()));
        while ((inputLine = in.readLine()) != null) {
            jsonTxt = jsonTxt + inputLine;
        }
        in.close();
        JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON(jsonTxt);
        JSONObject objData = (JSONObject)jsonObject.get("data");
        JSONArray objTranslation = (JSONArray)objData.get("translations");
        Iterator it = objTranslation.iterator();
        String val = null;
        while (it.hasNext()) {
            JSONObject obj = (JSONObject)it.next();
            val = (String)obj.get("translatedText");
            System.out.println("----------value-------------" + val);
        }
        return val;
    }

    public static String textFormatter(String input) {
        Inflector inflector = new Inflector();
        input = inflector.underscore(input, new char[0]);
        input = inflector.humanize(input, new String[0]);
        input = inflector.titleCase(input, new String[0]);
        return input;
    }

    public Map<Long, KeyValue> readFile(String fileName) {
        System.out.println("=================File reading start ==============================");
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        HashMap<Long, KeyValue> map = new HashMap<Long, KeyValue>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(fileName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            long count = 0L;
            while ((strLine = br.readLine()) != null) {
                ++count;
                if (strLine != null && !strLine.equals("") && !strLine.equals("null")) {
                    String[] arr = strLine.split(":");
                    if (arr != null && arr.length == 2) {
                        if (arr[1] == null) continue;
                        KeyValue keyValue = new KeyValue();
                        String valueTobeParse = arr[1].trim();
                        if (valueTobeParse.contains(",")) {
                            keyValue.setComma(true);
                            valueTobeParse = valueTobeParse.substring(1, valueTobeParse.length() - 2);
                        } else {
                            keyValue.setComma(false);
                            valueTobeParse = valueTobeParse.substring(1, valueTobeParse.length() - 1);
                        }
                        keyValue.setKey(arr[0]);
                        keyValue.setValue(valueTobeParse);
                        list.add(keyValue);
                        map.put(count, keyValue);
                        continue;
                    }
                    map.put(count, new KeyValue(strLine));
                    continue;
                }
                map.put(count, null);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error in file reading :" + e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    public void writeFile() {
    }

    public static void main(String[] args) throws Exception {
        File[] listOfFiles;
        Long startTime = System.currentTimeMillis();
        LanguageTranslationUtility obj = new LanguageTranslationUtility(TARGET_LANGUAGE);
        File folder = new File(SOURCE_FILE_PATH);
        for (File inputFile : listOfFiles = folder.listFiles()) {
            if (!inputFile.isFile()) continue;
            System.out.println("==================" + inputFile.getName() + "================================");
            Map<Long, KeyValue> map = obj.readFile("/opt/serosoft/v2_uploads/english//" + inputFile.getName());
            File file = new File("/opt/serosoft/v2_uploads/converted//" + inputFile.getName());
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (long i = 1L; i <= (long)map.size(); ++i) {
                KeyValue keyValue = map.get(i);
                System.out.println("======keyValue=====" + keyValue);
                if (keyValue != null && keyValue.getValue() != null) {
                    String value = LanguageTranslationUtility.textFormatter(keyValue.getValue());
                    if (keyValue.isComma()) {
                        bw.write(keyValue.getKey() + ":'" + obj.translator(value) + "',");
                        bw.write("\n");
                        continue;
                    }
                    bw.write(keyValue.getKey() + ":'" + obj.translator(value) + "'");
                    bw.write("\n");
                    continue;
                }
                if (keyValue == null) {
                    bw.write("\n");
                    continue;
                }
                bw.write(keyValue.getKey());
                bw.write("\n");
            }
            bw.close();
            Long endTime = System.currentTimeMillis();
            DecimalFormat formatter = new DecimalFormat("#0.00000");
            System.out.print("Execution time is " + formatter.format((double)(endTime - startTime) / 1000.0 / 60.0) + " minutes");
        }
    }
}

