/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceAnnotationMethodInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class SourceTypeConverter {
    public static final int FIELD = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int METHOD = 4;
    public static final int MEMBER_TYPE = 8;
    public static final int FIELD_INITIALIZATION = 16;
    public static final int FIELD_AND_METHOD = 7;
    public static final int LOCAL_TYPE = 32;
    public static final int NONE = 0;
    private int flags;
    private CompilationUnitDeclaration unit;
    private Parser parser;
    private ProblemReporter problemReporter;
    private ICompilationUnit cu;
    private char[] source;
    private HashMap annotationPositions;
    private boolean has1_5Compliance;
    int namePos;

    private SourceTypeConverter(int flags, ProblemReporter problemReporter) {
        this.flags = flags;
        this.problemReporter = problemReporter;
        this.has1_5Compliance = problemReporter.options.complianceLevel >= 0x310000L;
    }

    public static CompilationUnitDeclaration buildCompilationUnit(ISourceType[] sourceTypes, int flags, ProblemReporter problemReporter, CompilationResult compilationResult) {
        SourceTypeConverter converter2 = new SourceTypeConverter(flags, problemReporter);
        try {
            return converter2.convert(sourceTypes, compilationResult);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private CompilationUnitDeclaration convert(ISourceType[] sourceTypes, CompilationResult compilationResult) throws JavaModelException {
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        if (sourceTypes.length == 0) {
            return this.unit;
        }
        SourceTypeElementInfo topLevelTypeInfo = (SourceTypeElementInfo)sourceTypes[0];
        org.eclipse.jdt.core.ICompilationUnit cuHandle = topLevelTypeInfo.getHandle().getCompilationUnit();
        this.cu = (ICompilationUnit)((Object)cuHandle);
        this.annotationPositions = ((CompilationUnitElementInfo)((JavaElement)((Object)this.cu)).getElementInfo()).annotationPositions;
        if (this.has1_5Compliance && this.annotationPositions != null && this.annotationPositions.size() > 10) {
            return new Parser(this.problemReporter, true).dietParse(this.cu, compilationResult);
        }
        int start = topLevelTypeInfo.getNameSourceStart();
        int end = topLevelTypeInfo.getNameSourceEnd();
        String[] packageName = ((PackageFragment)cuHandle.getParent()).names;
        if (packageName.length > 0) {
            this.unit.currentPackage = this.createImportReference(packageName, start, end, false, 0);
        }
        IImportDeclaration[] importDeclarations = topLevelTypeInfo.getHandle().getCompilationUnit().getImports();
        int importCount = importDeclarations.length;
        this.unit.imports = new ImportReference[importCount];
        int i = 0;
        while (i < importCount) {
            ImportDeclaration importDeclaration = (ImportDeclaration)importDeclarations[i];
            ISourceImport sourceImport = (ISourceImport)importDeclaration.getElementInfo();
            String nameWithoutStar = importDeclaration.getNameWithoutStar();
            this.unit.imports[i] = this.createImportReference(Util.splitOn('.', nameWithoutStar, 0, nameWithoutStar.length()), sourceImport.getDeclarationSourceStart(), sourceImport.getDeclarationSourceEnd(), importDeclaration.isOnDemand(), sourceImport.getModifiers());
            ++i;
        }
        try {
            int typeCount = sourceTypes.length;
            TypeDeclaration[] types = new TypeDeclaration[typeCount];
            int i2 = 0;
            while (i2 < typeCount) {
                SourceTypeElementInfo typeInfo = (SourceTypeElementInfo)sourceTypes[i2];
                types[i2] = this.convert((SourceType)typeInfo.getHandle(), compilationResult);
                ++i2;
            }
            this.unit.types = types;
            return this.unit;
        }
        catch (AnonymousMemberFound anonymousMemberFound) {
            return new Parser(this.problemReporter, true).parse(this.cu, compilationResult);
        }
    }

    private void addIdentifiers(String typeSignature, int start, int endExclusive, int identCount, ArrayList fragments) {
        if (identCount == 1) {
            char[] identifier = new char[endExclusive - start];
            typeSignature.getChars(start, endExclusive, identifier, 0);
            fragments.add(identifier);
        } else {
            fragments.add(this.extractIdentifiers(typeSignature, start, endExclusive - 1, identCount));
        }
    }

    private Initializer convert(InitializerElementInfo initializerInfo, CompilationResult compilationResult) throws JavaModelException {
        Block block = new Block(0);
        Initializer initializer = new Initializer(block, 0);
        int start = initializerInfo.getDeclarationSourceStart();
        int end = initializerInfo.getDeclarationSourceEnd();
        initializer.sourceStart = initializer.declarationSourceStart = start;
        initializer.sourceEnd = initializer.declarationSourceEnd = end;
        initializer.modifiers = initializerInfo.getModifiers();
        IJavaElement[] children = initializerInfo.getChildren();
        int typesLength = children.length;
        if (typesLength > 0) {
            Statement[] statements = new Statement[typesLength];
            int i = 0;
            while (i < typesLength) {
                SourceType type = (SourceType)children[i];
                TypeDeclaration localType = this.convert(type, compilationResult);
                if ((localType.bits & 0x200) != 0) {
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                    expression.type = localType.superclass;
                    localType.superclass = null;
                    localType.superInterfaces = null;
                    localType.allocation = expression;
                    statements[i] = expression;
                } else {
                    statements[i] = localType;
                }
                ++i;
            }
            block.statements = statements;
        }
        return initializer;
    }

    private FieldDeclaration convert(SourceField fieldHandle, TypeDeclaration type, CompilationResult compilationResult) throws JavaModelException {
        char[] initializationSource;
        boolean isEnumConstant;
        SourceFieldElementInfo fieldInfo = (SourceFieldElementInfo)fieldHandle.getElementInfo();
        FieldDeclaration field = new FieldDeclaration();
        int start = fieldInfo.getNameSourceStart();
        int end = fieldInfo.getNameSourceEnd();
        field.name = fieldHandle.getElementName().toCharArray();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.declarationSourceStart = fieldInfo.getDeclarationSourceStart();
        field.declarationSourceEnd = fieldInfo.getDeclarationSourceEnd();
        int modifiers = fieldInfo.getModifiers();
        boolean bl = isEnumConstant = (modifiers & 0x4000) != 0;
        if (isEnumConstant) {
            field.modifiers = modifiers & 0xFFFFBFFF;
        } else {
            field.modifiers = modifiers;
            field.type = this.createTypeReference(fieldInfo.getTypeName(), start, end);
        }
        if (this.has1_5Compliance) {
            field.annotations = this.convertAnnotations(fieldHandle);
        }
        if ((this.flags & 0x10) != 0 && (initializationSource = fieldInfo.getInitializationSource()) != null) {
            if (this.parser == null) {
                this.parser = new Parser(this.problemReporter, true);
            }
            this.parser.parse(field, type, this.unit, initializationSource);
        }
        if ((this.flags & 0x20) != 0) {
            IJavaElement[] children = fieldInfo.getChildren();
            int childrenLength = children.length;
            if (childrenLength == 1) {
                field.initialization = this.convert(children[0], isEnumConstant ? field : null, compilationResult);
            } else if (childrenLength > 1) {
                ArrayInitializer initializer = new ArrayInitializer();
                field.initialization = initializer;
                Expression[] expressions = new Expression[childrenLength];
                initializer.expressions = expressions;
                int i = 0;
                while (i < childrenLength) {
                    expressions[i] = this.convert(children[i], isEnumConstant ? field : null, compilationResult);
                    ++i;
                }
            }
        }
        return field;
    }

    private QualifiedAllocationExpression convert(IJavaElement localType, FieldDeclaration enumConstant, CompilationResult compilationResult) throws JavaModelException {
        TypeDeclaration anonymousLocalTypeDeclaration = this.convert((SourceType)localType, compilationResult);
        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(anonymousLocalTypeDeclaration);
        expression.type = anonymousLocalTypeDeclaration.superclass;
        anonymousLocalTypeDeclaration.superclass = null;
        anonymousLocalTypeDeclaration.superInterfaces = null;
        anonymousLocalTypeDeclaration.allocation = expression;
        if (enumConstant != null) {
            anonymousLocalTypeDeclaration.modifiers &= 0xFFFFBFFF;
            expression.enumConstant = enumConstant;
            expression.type = null;
        }
        return expression;
    }

    private AbstractMethodDeclaration convert(SourceMethod methodHandle, SourceMethodElementInfo methodInfo, CompilationResult compilationResult) throws JavaModelException {
        IJavaElement[] children;
        int typesLength;
        char[][] exceptionTypeNames;
        int exceptionCount;
        int i;
        int argumentCount;
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int parameterCount;
        char[][] typeParameterNames;
        int start = methodInfo.getNameSourceStart();
        int end = methodInfo.getNameSourceEnd();
        TypeParameter[] typeParams = null;
        if (this.has1_5Compliance && (typeParameterNames = methodInfo.getTypeParameterNames()) != null && (parameterCount = typeParameterNames.length) > 0) {
            char[][][] typeParameterBounds = methodInfo.getTypeParameterBounds();
            typeParams = new TypeParameter[parameterCount];
            int i2 = 0;
            while (i2 < parameterCount) {
                typeParams[i2] = this.createTypeParameter(typeParameterNames[i2], typeParameterBounds[i2], start, end);
                ++i2;
            }
        }
        int modifiers = methodInfo.getModifiers();
        if (methodInfo.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.bits &= 0xFFFFFF7F;
            method = decl;
            decl.typeParameters = typeParams;
        } else {
            if (methodInfo.isAnnotationMethod()) {
                boolean hasDefaultValue;
                AnnotationMethodDeclaration annotationMethodDeclaration = new AnnotationMethodDeclaration(compilationResult);
                SourceAnnotationMethodInfo annotationMethodInfo = (SourceAnnotationMethodInfo)methodInfo;
                boolean bl = hasDefaultValue = annotationMethodInfo.defaultValueStart != -1 || annotationMethodInfo.defaultValueEnd != -1;
                if ((this.flags & 0x10) != 0 && hasDefaultValue) {
                    char[] defaultValueSource = CharOperation.subarray(this.getSource(), annotationMethodInfo.defaultValueStart, annotationMethodInfo.defaultValueEnd + 1);
                    if (defaultValueSource != null) {
                        Expression expression = this.parseMemberValue(defaultValueSource);
                        if (expression != null) {
                            annotationMethodDeclaration.defaultValue = expression;
                        }
                    } else {
                        hasDefaultValue = false;
                    }
                }
                if (hasDefaultValue) {
                    modifiers |= 0x20000;
                }
                decl = annotationMethodDeclaration;
            } else {
                decl = new MethodDeclaration(compilationResult);
            }
            ((MethodDeclaration)decl).returnType = this.createTypeReference(methodInfo.getReturnTypeName(), start, end);
            ((MethodDeclaration)decl).typeParameters = typeParams;
            method = decl;
        }
        method.selector = methodHandle.getElementName().toCharArray();
        boolean isVarargs = (modifiers & 0x80) != 0;
        method.modifiers = modifiers & 0xFFFFFF7F;
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = methodInfo.getDeclarationSourceStart();
        method.declarationSourceEnd = methodInfo.getDeclarationSourceEnd();
        if (this.has1_5Compliance) {
            method.annotations = this.convertAnnotations(methodHandle);
        }
        String[] argumentTypeSignatures = methodHandle.getParameterTypes();
        char[][] argumentNames = methodInfo.getArgumentNames();
        int n = argumentCount = argumentTypeSignatures == null ? 0 : argumentTypeSignatures.length;
        if (argumentCount > 0) {
            long position = ((long)start << 32) + (long)end;
            method.arguments = new Argument[argumentCount];
            i = 0;
            while (i < argumentCount) {
                TypeReference typeReference = this.createTypeReference(argumentTypeSignatures[i], start, end);
                if (isVarargs && i == argumentCount - 1) {
                    typeReference.bits |= 0x4000;
                }
                method.arguments[i] = new Argument(argumentNames[i], position, typeReference, 0);
                ++i;
            }
        }
        int n2 = exceptionCount = (exceptionTypeNames = methodInfo.getExceptionTypeNames()) == null ? 0 : exceptionTypeNames.length;
        if (exceptionCount > 0) {
            method.thrownExceptions = new TypeReference[exceptionCount];
            i = 0;
            while (i < exceptionCount) {
                method.thrownExceptions[i] = this.createTypeReference(exceptionTypeNames[i], start, end);
                ++i;
            }
        }
        if ((this.flags & 0x20) != 0 && (typesLength = (children = methodInfo.getChildren()).length) != 0) {
            Statement[] statements = new Statement[typesLength];
            int i3 = 0;
            while (i3 < typesLength) {
                SourceType type = (SourceType)children[i3];
                TypeDeclaration localType = this.convert(type, compilationResult);
                if ((localType.bits & 0x200) != 0) {
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                    expression.type = localType.superclass;
                    localType.superclass = null;
                    localType.superInterfaces = null;
                    localType.allocation = expression;
                    statements[i3] = expression;
                } else {
                    statements[i3] = localType;
                }
                ++i3;
            }
            method.statements = statements;
        }
        return method;
    }

    private TypeDeclaration convert(SourceType typeHandle, CompilationResult compilationResult) throws JavaModelException {
        boolean needMethod;
        int length;
        char[][] interfaceNames;
        int interfaceCount;
        int end;
        int start;
        SourceTypeElementInfo typeInfo = (SourceTypeElementInfo)typeHandle.getElementInfo();
        if (typeInfo.isAnonymousMember()) {
            throw new AnonymousMemberFound();
        }
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (typeInfo.getEnclosingType() == null) {
            if (typeHandle.isAnonymous()) {
                type.name = CharOperation.NO_CHAR;
                type.bits |= 0x300;
            } else if (typeHandle.isLocal()) {
                type.bits |= 0x100;
            }
        } else {
            type.bits |= 0x400;
        }
        if ((type.bits & 0x200) == 0) {
            type.name = typeInfo.getName();
        }
        type.name = typeInfo.getName();
        type.sourceStart = start = typeInfo.getNameSourceStart();
        type.sourceEnd = end = typeInfo.getNameSourceEnd();
        type.modifiers = typeInfo.getModifiers();
        type.declarationSourceStart = typeInfo.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = typeInfo.getDeclarationSourceEnd();
        if (this.has1_5Compliance) {
            type.annotations = this.convertAnnotations(typeHandle);
            char[][] typeParameterNames = typeInfo.getTypeParameterNames();
            if (typeParameterNames.length > 0) {
                int parameterCount = typeParameterNames.length;
                char[][][] typeParameterBounds = typeInfo.getTypeParameterBounds();
                type.typeParameters = new TypeParameter[parameterCount];
                int i = 0;
                while (i < parameterCount) {
                    type.typeParameters[i] = this.createTypeParameter(typeParameterNames[i], typeParameterBounds[i], start, end);
                    ++i;
                }
            }
        }
        if (typeInfo.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(typeInfo.getSuperclassName(), start, end);
            type.superclass.bits |= 0x10;
        }
        int n = interfaceCount = (interfaceNames = typeInfo.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        if (interfaceCount > 0) {
            type.superInterfaces = new TypeReference[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                type.superInterfaces[i] = this.createTypeReference(interfaceNames[i], start, end);
                type.superInterfaces[i].bits |= 0x10;
                ++i;
            }
        }
        if ((this.flags & 8) != 0) {
            SourceType[] sourceMemberTypes = typeInfo.getMemberTypeHandles();
            int sourceMemberTypeCount = sourceMemberTypes.length;
            type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
            int i = 0;
            while (i < sourceMemberTypeCount) {
                type.memberTypes[i] = this.convert(sourceMemberTypes[i], compilationResult);
                ++i;
            }
        }
        InitializerElementInfo[] initializers = null;
        int initializerCount = 0;
        if ((this.flags & 0x20) != 0) {
            initializers = typeInfo.getInitializers();
            initializerCount = initializers.length;
        }
        SourceField[] sourceFields = null;
        int sourceFieldCount = 0;
        if ((this.flags & 1) != 0) {
            sourceFields = typeInfo.getFieldHandles();
            sourceFieldCount = sourceFields.length;
        }
        if ((length = initializerCount + sourceFieldCount) > 0) {
            type.fields = new FieldDeclaration[length];
            int i = 0;
            while (i < initializerCount) {
                type.fields[i] = this.convert(initializers[i], compilationResult);
                ++i;
            }
            int index = 0;
            int i2 = initializerCount;
            while (i2 < length) {
                type.fields[i2] = this.convert(sourceFields[index++], type, compilationResult);
                ++i2;
            }
        }
        boolean needConstructor = (this.flags & 2) != 0;
        boolean bl = needMethod = (this.flags & 4) != 0;
        if (needConstructor || needMethod) {
            boolean isAbstract;
            SourceMethod[] sourceMethods = typeInfo.getMethodHandles();
            int sourceMethodCount = sourceMethods.length;
            int extraConstructor = 0;
            int methodCount = 0;
            int kind = TypeDeclaration.kind(type.modifiers);
            boolean bl2 = isAbstract = kind == 2 || kind == 4;
            if (!isAbstract) {
                extraConstructor = needConstructor ? 1 : 0;
                int i = 0;
                while (i < sourceMethodCount) {
                    if (sourceMethods[i].isConstructor()) {
                        if (needConstructor) {
                            extraConstructor = 0;
                            ++methodCount;
                        }
                    } else if (needMethod) {
                        ++methodCount;
                    }
                    ++i;
                }
            } else {
                methodCount = needMethod ? sourceMethodCount : 0;
            }
            type.methods = new AbstractMethodDeclaration[methodCount + extraConstructor];
            if (extraConstructor != 0) {
                type.methods[0] = type.createDefaultConstructor(false, false);
            }
            int index = 0;
            boolean hasAbstractMethods = false;
            int i = 0;
            while (i < sourceMethodCount) {
                SourceMethod sourceMethod = sourceMethods[i];
                SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)sourceMethod.getElementInfo();
                boolean isConstructor = methodInfo.isConstructor();
                if ((methodInfo.getModifiers() & 0x400) != 0) {
                    hasAbstractMethods = true;
                }
                if (isConstructor && needConstructor || !isConstructor && needMethod) {
                    AbstractMethodDeclaration method = this.convert(sourceMethod, methodInfo, compilationResult);
                    if (isAbstract || method.isAbstract()) {
                        method.modifiers |= 0x1000000;
                    }
                    type.methods[extraConstructor + index++] = method;
                }
                ++i;
            }
            if (hasAbstractMethods) {
                type.bits |= 0x800;
            }
        }
        return type;
    }

    private Annotation[] convertAnnotations(JavaElement element) {
        if (this.annotationPositions == null) {
            return null;
        }
        char[] cuSource = this.getSource();
        long[] positions = (long[])this.annotationPositions.get(element);
        if (positions == null) {
            return null;
        }
        int length = positions.length;
        Annotation[] annotations = new Annotation[length];
        int recordedAnnotations = 0;
        int i = 0;
        while (i < length) {
            Expression expression;
            long position = positions[i];
            int start = (int)(position >>> 32);
            int end = (int)position;
            char[] annotationSource = CharOperation.subarray(cuSource, start, end + 1);
            if (annotationSource != null && (expression = this.parseMemberValue(annotationSource)) instanceof Annotation) {
                annotations[recordedAnnotations++] = (Annotation)expression;
            }
            ++i;
        }
        if (length != recordedAnnotations) {
            Annotation[] annotationArray = annotations;
            annotations = new Annotation[recordedAnnotations];
            System.arraycopy(annotationArray, 0, annotations, 0, recordedAnnotations);
        }
        return annotations;
    }

    private ImportReference createImportReference(String[] importName, int start, int end, boolean onDemand, int modifiers) {
        int length = importName.length;
        long[] positions = new long[length];
        long position = ((long)start << 32) + (long)end;
        char[][] qImportName = new char[length][];
        int i = 0;
        while (i < length) {
            qImportName[i] = importName[i].toCharArray();
            positions[i] = position;
            ++i;
        }
        return new ImportReference(qImportName, positions, onDemand, modifiers);
    }

    private TypeParameter createTypeParameter(char[] typeParameterName, char[][] typeParameterBounds, int start, int end) {
        int length;
        TypeParameter parameter = new TypeParameter();
        parameter.name = typeParameterName;
        parameter.sourceStart = start;
        parameter.sourceEnd = end;
        if (typeParameterBounds != null && (length = typeParameterBounds.length) > 0) {
            parameter.type = this.createTypeReference(typeParameterBounds[0], start, end);
            if (length > 1) {
                parameter.bounds = new TypeReference[length - 1];
                int i = 1;
                while (i < length) {
                    TypeReference bound = this.createTypeReference(typeParameterBounds[i], start, end);
                    bound.bits |= 0x10;
                    parameter.bounds[i - 1] = bound;
                    ++i;
                }
            }
        }
        return parameter;
    }

    private TypeReference createTypeReference(char[] typeName, int start, int end) {
        int length = typeName.length;
        this.namePos = 0;
        return this.decodeType(typeName, length, start, end);
    }

    private TypeReference createTypeReference(String typeSignature, int start, int end) {
        int length = typeSignature.length();
        this.namePos = 0;
        return this.decodeType(typeSignature, length, start, end);
    }

    /*
     * Unable to fully structure code
     */
    private TypeReference decodeType(String typeSignature, int length, int start, int end) {
        identCount = 1;
        dim = 0;
        nameFragmentStart = this.namePos;
        nameFragmentEnd = -1;
        nameStarted = false;
        fragments = null;
        block19: while (this.namePos < length) {
            currentChar = typeSignature.charAt(this.namePos);
            switch (currentChar) {
                case 'Z': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'B': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.BYTE.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.BYTE.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'C': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.CHAR.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.CHAR.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'D': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'F': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.FLOAT.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'I': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.INT.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.INT.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'J': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.LONG.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.LONG.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'S': {
                    if (!nameStarted) {
                        ++this.namePos;
                        if (dim == 0) {
                            return new SingleTypeReference(TypeBinding.SHORT.simpleName, ((long)start << 32) + (long)end);
                        }
                        return new ArrayTypeReference(TypeBinding.SHORT.simpleName, dim, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'V': {
                    if (!nameStarted) {
                        ++this.namePos;
                        new SingleTypeReference(TypeBinding.VOID.simpleName, ((long)start << 32) + (long)end);
                    }
                    ** GOTO lbl123
                }
                case 'L': 
                case 'Q': {
                    if (!nameStarted) {
                        nameFragmentStart = this.namePos + 1;
                        nameStarted = true;
                    }
                    ** GOTO lbl123
                }
                case '*': {
                    ++this.namePos;
                    result = new Wildcard(0);
                    result.sourceStart = start;
                    result.sourceEnd = end;
                    return result;
                }
                case '+': {
                    ++this.namePos;
                    result = new Wildcard(1);
                    result.bound = this.decodeType(typeSignature, length, start, end);
                    result.sourceStart = start;
                    result.sourceEnd = end;
                    return result;
                }
                case '-': {
                    ++this.namePos;
                    result = new Wildcard(2);
                    result.bound = this.decodeType(typeSignature, length, start, end);
                    result.sourceStart = start;
                    result.sourceEnd = end;
                    return result;
                }
                case '[': {
                    ++dim;
                    ** GOTO lbl123
                }
                case ';': 
                case '>': {
                    nameFragmentEnd = this.namePos - 1;
                    ++this.namePos;
                    break block19;
                }
                case '$': 
                case '.': {
                    if (!nameStarted) {
                        nameFragmentStart = this.namePos + 1;
                        nameStarted = true;
                    } else if (this.namePos > nameFragmentStart) {
                        ++identCount;
                    }
                    ** GOTO lbl123
                }
                case '<': {
                    nameFragmentEnd = this.namePos - 1;
                    if (!this.has1_5Compliance) break block19;
                    if (fragments == null) {
                        fragments = new ArrayList<TypeReference[][]>(2);
                    }
                    this.addIdentifiers(typeSignature, nameFragmentStart, nameFragmentEnd + 1, identCount, fragments);
                    ++this.namePos;
                    arguments = this.decodeTypeArguments(typeSignature, length, start, end);
                    fragments.add(arguments);
                    identCount = 1;
                    nameStarted = false;
                }
lbl123:
                // 15 sources

                default: {
                    ++this.namePos;
                }
            }
        }
        if (fragments == null) {
            if (identCount == 1) {
                if (dim == 0) {
                    nameFragment = new char[nameFragmentEnd - nameFragmentStart + 1];
                    typeSignature.getChars(nameFragmentStart, nameFragmentEnd + 1, nameFragment, 0);
                    return new SingleTypeReference(nameFragment, ((long)start << 32) + (long)end);
                }
                nameFragment = new char[nameFragmentEnd - nameFragmentStart + 1];
                typeSignature.getChars(nameFragmentStart, nameFragmentEnd + 1, nameFragment, 0);
                return new ArrayTypeReference(nameFragment, dim, ((long)start << 32) + (long)end);
            }
            positions = new long[identCount];
            pos = ((long)start << 32) + (long)end;
            i = 0;
            while (i < identCount) {
                positions[i] = pos;
                ++i;
            }
            identifiers = this.extractIdentifiers(typeSignature, nameFragmentStart, nameFragmentEnd, identCount);
            if (dim == 0) {
                return new QualifiedTypeReference(identifiers, positions);
            }
            return new ArrayQualifiedTypeReference(identifiers, dim, positions);
        }
        if (nameStarted) {
            this.addIdentifiers(typeSignature, nameFragmentStart, nameFragmentEnd + 1, identCount, fragments);
        }
        if ((fragmentLength = fragments.size()) == 2 && (firstFragment = fragments.get(0)) instanceof char[]) {
            return new ParameterizedSingleTypeReference((char[])firstFragment, (TypeReference[])fragments.get(1), dim, ((long)start << 32) + (long)end);
        }
        identCount = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                identCount += ((char[][])element).length;
            } else if (element instanceof char[]) {
                ++identCount;
            }
            ++i;
        }
        tokens = new char[identCount][];
        arguments = new TypeReference[identCount][];
        index = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                fragmentTokens = (char[][])element;
                fragmentTokenLength = fragmentTokens.length;
                System.arraycopy(fragmentTokens, 0, tokens, index, fragmentTokenLength);
                index += fragmentTokenLength;
            } else if (element instanceof char[]) {
                tokens[index++] = (char[])element;
            } else {
                arguments[index - 1] = (TypeReference[])element;
            }
            ++i;
        }
        positions = new long[identCount];
        pos = ((long)start << 32) + (long)end;
        i = 0;
        while (i < identCount) {
            positions[i] = pos;
            ++i;
        }
        return new ParameterizedQualifiedTypeReference(tokens, arguments, dim, positions);
    }

    /*
     * Unable to fully structure code
     */
    private TypeReference decodeType(char[] typeName, int length, int start, int end) {
        identCount = 1;
        dim = 0;
        nameFragmentStart = this.namePos;
        nameFragmentEnd = -1;
        fragments = null;
        block12: while (this.namePos < length) {
            currentChar = typeName[this.namePos];
            switch (currentChar) {
                case '?': {
                    ++this.namePos;
                    while (typeName[this.namePos] == ' ') {
                        ++this.namePos;
                    }
                    block8 : switch (typeName[this.namePos]) {
                        case 's': {
                            max = TypeConstants.WILDCARD_SUPER.length - 1;
                            ahead = 1;
                            while (ahead < max) {
                                if (typeName[this.namePos + ahead] != TypeConstants.WILDCARD_SUPER[ahead + 1]) break block8;
                                ++ahead;
                            }
                            this.namePos += max;
                            result = new Wildcard(2);
                            result.bound = this.decodeType(typeName, length, start, end);
                            result.sourceStart = start;
                            result.sourceEnd = end;
                            return result;
                        }
                        case 'e': {
                            max = TypeConstants.WILDCARD_EXTENDS.length - 1;
                            ahead = 1;
                            while (ahead < max) {
                                if (typeName[this.namePos + ahead] != TypeConstants.WILDCARD_EXTENDS[ahead + 1]) break block8;
                                ++ahead;
                            }
                            this.namePos += max;
                            result = new Wildcard(1);
                            result.bound = this.decodeType(typeName, length, start, end);
                            result.sourceStart = start;
                            result.sourceEnd = end;
                            return result;
                        }
                    }
                    result = new Wildcard(0);
                    result.sourceStart = start;
                    result.sourceEnd = end;
                    return result;
                }
                case '[': {
                    if (dim == 0) {
                        nameFragmentEnd = this.namePos - 1;
                    }
                    ++dim;
                    ** GOTO lbl74
                }
                case ']': {
                    ** GOTO lbl74
                }
                case ',': 
                case '>': {
                    break block12;
                }
                case '.': {
                    if (nameFragmentStart < 0) {
                        nameFragmentStart = this.namePos + 1;
                    }
                    ++identCount;
                    ** GOTO lbl74
                }
                case '<': {
                    if (!this.has1_5Compliance) break block12;
                    if (fragments == null) {
                        fragments = new ArrayList<Object>(2);
                    }
                    nameFragmentEnd = this.namePos - 1;
                    identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, this.namePos);
                    fragments.add(identifiers);
                    ++this.namePos;
                    arguments = this.decodeTypeArguments(typeName, length, start, end);
                    fragments.add(arguments);
                    identCount = 0;
                    nameFragmentStart = -1;
                    nameFragmentEnd = -1;
                }
lbl74:
                // 5 sources

                default: {
                    ++this.namePos;
                }
            }
        }
        if (nameFragmentEnd < 0) {
            nameFragmentEnd = this.namePos - 1;
        }
        if (fragments == null) {
            if (identCount == 1) {
                if (dim == 0) {
                    if (nameFragmentStart != 0 || nameFragmentEnd >= 0) {
                        nameFragmentLength = nameFragmentEnd - nameFragmentStart + 1;
                        nameFragment = new char[nameFragmentLength];
                        System.arraycopy(typeName, nameFragmentStart, nameFragment, 0, nameFragmentLength);
                    } else {
                        nameFragment = typeName;
                    }
                    return new SingleTypeReference(nameFragment, ((long)start << 32) + (long)end);
                }
                nameFragmentLength = nameFragmentEnd - nameFragmentStart + 1;
                nameFragment = new char[nameFragmentLength];
                System.arraycopy(typeName, nameFragmentStart, nameFragment, 0, nameFragmentLength);
                return new ArrayTypeReference(nameFragment, dim, ((long)start << 32) + (long)end);
            }
            positions = new long[identCount];
            pos = ((long)start << 32) + (long)end;
            i = 0;
            while (i < identCount) {
                positions[i] = pos;
                ++i;
            }
            identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, nameFragmentEnd + 1);
            if (dim == 0) {
                return new QualifiedTypeReference(identifiers, positions);
            }
            return new ArrayQualifiedTypeReference(identifiers, dim, positions);
        }
        if (nameFragmentStart > 0 && nameFragmentStart < length) {
            identifiers = CharOperation.splitOn('.', typeName, nameFragmentStart, nameFragmentEnd + 1);
            fragments.add(identifiers);
        }
        if ((fragmentLength = fragments.size()) == 2 && (firstFragment = (char[][])fragments.get(0)).length == 1) {
            return new ParameterizedSingleTypeReference(firstFragment[0], (TypeReference[])fragments.get(1), dim, ((long)start << 32) + (long)end);
        }
        identCount = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                identCount += ((char[][])element).length;
            }
            ++i;
        }
        tokens = new char[identCount][];
        arguments = new TypeReference[identCount][];
        index = 0;
        i = 0;
        while (i < fragmentLength) {
            element = fragments.get(i);
            if (element instanceof char[][]) {
                fragmentTokens = (char[][])element;
                fragmentTokenLength = fragmentTokens.length;
                System.arraycopy(fragmentTokens, 0, tokens, index, fragmentTokenLength);
                index += fragmentTokenLength;
            } else {
                arguments[index - 1] = (TypeReference[])element;
            }
            ++i;
        }
        positions = new long[identCount];
        pos = ((long)start << 32) + (long)end;
        i = 0;
        while (i < identCount) {
            positions[i] = pos;
            ++i;
        }
        return new ParameterizedQualifiedTypeReference(tokens, arguments, dim, positions);
    }

    private TypeReference[] decodeTypeArguments(char[] typeName, int length, int start, int end) {
        ArrayList<TypeReference> argumentList = new ArrayList<TypeReference>(1);
        int count = 0;
        while (this.namePos < length) {
            TypeReference argument = this.decodeType(typeName, length, start, end);
            ++count;
            argumentList.add(argument);
            if (this.namePos >= length || typeName[this.namePos] == '>') break;
            ++this.namePos;
        }
        TypeReference[] typeArguments = new TypeReference[count];
        argumentList.toArray(typeArguments);
        return typeArguments;
    }

    private TypeReference[] decodeTypeArguments(String typeSignature, int length, int start, int end) {
        ArrayList<TypeReference> argumentList = new ArrayList<TypeReference>(1);
        int count = 0;
        while (this.namePos < length) {
            TypeReference argument = this.decodeType(typeSignature, length, start, end);
            ++count;
            argumentList.add(argument);
            if (this.namePos >= length || typeSignature.charAt(this.namePos) == '>') break;
        }
        TypeReference[] typeArguments = new TypeReference[count];
        argumentList.toArray(typeArguments);
        return typeArguments;
    }

    private char[][] extractIdentifiers(String typeSignature, int start, int endInclusive, int identCount) {
        char[][] result = new char[identCount][];
        int charIndex = start;
        int i = 0;
        while (charIndex < endInclusive) {
            if (typeSignature.charAt(charIndex) == '.') {
                int n = i++;
                char[] cArray = new char[charIndex - start];
                result[n] = cArray;
                typeSignature.getChars(start, charIndex, cArray, 0);
                start = ++charIndex;
                continue;
            }
            ++charIndex;
        }
        int n = i++;
        char[] cArray = new char[charIndex - start + 1];
        result[n] = cArray;
        typeSignature.getChars(start, charIndex + 1, cArray, 0);
        return result;
    }

    private char[] getSource() {
        if (this.source == null) {
            this.source = this.cu.getContents();
        }
        return this.source;
    }

    private Expression parseMemberValue(char[] memberValue) {
        if (this.parser == null) {
            this.parser = new Parser(this.problemReporter, true);
        }
        return this.parser.parseMemberValue(memberValue, 0, memberValue.length, this.unit);
    }

    static class AnonymousMemberFound
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AnonymousMemberFound() {
        }
    }
}

