/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.regions;

import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.nonstop.HibernateNonstopCacheExceptionHandler;
import org.hibernate.cache.ehcache.internal.regions.EhcacheDataRegion;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cfg.Settings;

public class EhcacheTransactionalDataRegion
extends EhcacheDataRegion
implements TransactionalDataRegion {
    private static final int LOCAL_LOCK_PROVIDER_CONCURRENCY = 128;
    protected final Settings settings;
    protected final CacheDataDescription metadata;
    private final CacheLockProvider lockProvider;

    EhcacheTransactionalDataRegion(EhcacheAccessStrategyFactory accessStrategyFactory, Ehcache cache, Settings settings, CacheDataDescription metadata, Properties properties) {
        super(accessStrategyFactory, cache, properties);
        this.settings = settings;
        this.metadata = metadata;
        Object context = cache.getInternalContext();
        this.lockProvider = context instanceof CacheLockProvider ? (CacheLockProvider)context : new StripedReadWriteLockSync(128);
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public boolean isTransactionAware() {
        return false;
    }

    @Override
    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public final Object get(Object key) {
        try {
            Element element = this.cache.get(key);
            if (element == null) {
                return null;
            }
            return element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
                return null;
            }
            throw new CacheException(e);
        }
    }

    public final void put(Object key, Object value) throws CacheException {
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void remove(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void writeLock(Object key) {
        try {
            this.lockProvider.getSyncForKey(key).lock(LockType.WRITE);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void writeUnlock(Object key) {
        try {
            this.lockProvider.getSyncForKey(key).unlock(LockType.WRITE);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void readLock(Object key) {
        try {
            this.lockProvider.getSyncForKey(key).lock(LockType.WRITE);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final void readUnlock(Object key) {
        try {
            this.lockProvider.getSyncForKey(key).unlock(LockType.WRITE);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException(e);
        }
    }

    public final boolean locksAreIndependentOfCache() {
        return this.lockProvider instanceof StripedReadWriteLockSync;
    }
}

