/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.List;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.process.DelegatingComponent;
import org.modeshape.graph.query.process.ProcessingComponent;

public class LimitComponent
extends DelegatingComponent {
    private final Limit limit;

    public LimitComponent(ProcessingComponent delegate, Limit limit) {
        super(delegate);
        this.limit = limit;
        assert (this.limit != null);
    }

    @Override
    public List<Object[]> execute() {
        if (this.limit.rowLimit() == 0) {
            return this.emptyTuples();
        }
        List<Object[]> tuples = this.delegate().execute();
        if (this.limit.isOffset()) {
            if (this.limit.offset() >= tuples.size()) {
                return this.emptyTuples();
            }
            if (this.limit.hasRowLimited()) {
                int toIndex = Math.min(tuples.size(), Math.max(0, this.limit.offset() + this.limit.rowLimit()));
                tuples = tuples.subList(this.limit.offset(), toIndex);
            } else {
                tuples = tuples.subList(this.limit.offset(), tuples.size());
            }
        } else if (this.limit.hasRowLimited()) {
            int toIndex = Math.min(this.limit.rowLimit(), tuples.size());
            tuples = tuples.subList(0, toIndex);
        }
        return tuples;
    }
}

