CREATE TABLE `route_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `routeName` VARCHAR(60) NULL DEFAULT NULL,
  `responsiblePersonId` BIGINT(20) NULL DEFAULT NULL,
  `responsiblePersonName` VARCHAR(100) NULL DEFAULT NULL,
  `startLocation` BIGINT(20) NULL DEFAULT NULL,
  `endLocation` BIGINT(20) NULL DEFAULT NULL,
  `whetherRoundTrip` BIT(1) NULL DEFAULT NULL,
  `distance` DOUBLE(10,2) NULL DEFAULT NULL,
  `whetherActive` BIT(1) NULL DEFAULT NULL,
  `routeBillType` VARCHAR(45) NULL DEFAULT NULL,
  `feePlanId` BIGINT(20) NULL DEFAULT NULL,
  `droolsAgenda` VARCHAR(100) CHARACTER SET 'big5' NULL DEFAULT NULL,
  `droolsRuleRemarks` TEXT NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));


CREATE TABLE `route_location_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `locationCode` VARCHAR(45) NULL DEFAULT NULL,
  `locationName` VARCHAR(100) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));

CREATE TABLE `route_stops_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL DEFAULT NULL,
  `routeId` BIGINT(20) NULL DEFAULT NULL,
  `stopLocation` VARCHAR(100) NULL DEFAULT NULL,
  `routeStopType` VARCHAR(100) NULL DEFAULT NULL,
  `stopSeqOnward` INT(11) NULL DEFAULT NULL,
  `stopSeqReturn` INT(11) NULL DEFAULT NULL,
  `distanceOnward` DOUBLE(10,2) NULL DEFAULT NULL,
  `distanceReturn` DOUBLE(10,2) NULL DEFAULT NULL,
  `whetherActive` BIT(1) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `REV`));