DELIMITER $$
DROP PROCEDURE IF EXISTS V20220804132852__Create_examConcessionDurationDetailHistory $$
CREATE PROCEDURE V20220804132852__Create_examConcessionDurationDetailHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_concesession_duration_detail_history' )) THEN 
CREATE TABLE `exam_concesession_duration_detail_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `startDate` DATE  NOT NULL ,
  `endDate` DATE  NOT NULL ,
  `plannedActionDate` DATE  NOT NULL ,
  `actualActionDate` DATE  NOT NULL ,
  `requestActionStatus` VARCHAR(100) NOT NULL,
  `remark` VARCHAR(100) NOT NULL,
  `isLevelOne` VARCHAR(100) NULL DEFAULT NULL,
  `isLevelTwo` VARCHAR(100) NULL DEFAULT NULL,
  `approverId` BIGINT NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `concession_lastUpdateBy` (`lastUpdatedBy` ASC) ,
  INDEX `user_concession_approver` (`approverId` ASC) ,
  CONSTRAINT `concession_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users_history` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
CONSTRAINT `user_concession_User`
	FOREIGN KEY (`approverId`)
	REFERENCES `users_history` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);

END IF; 




END $$
CALL V20220804132852__Create_examConcessionDurationDetailHistory () $$ 
DROP PROCEDURE IF EXISTS V20220804132852__Create_examConcessionDurationDetailHistory $$ 
DELIMITER ;