DELIMITER $$
DROP PROCEDURE IF EXISTS V20240618224805__Update_UpdateOnlineEnquiryFlywayHistory $$
CREATE PROCEDURE V20240618224805__Update_UpdateOnlineEnquiryFlywayHistory()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @table_name := 'enquiry_form_additional_Setup_history';
SET @column_name := 'onlinePortalImagePath';

IF NOT EXISTS (
    SELECT column_name,table_name 
    FROM INFORMATION_SCHEMA.columns 
    WHERE LOWER(table_schema) = LOWER(DATABASE()) 
      AND LOWER(table_name) = LOWER(@table_name) 
      AND LOWER(column_name) = LOWER(@column_name)
) THEN
SET @table_name_new = (
SELECT distinct table_name 
    FROM INFORMATION_SCHEMA.columns 
    WHERE LOWER(table_schema) = LOWER(DATABASE()) 
      AND LOWER(table_name) = LOWER(@table_name) 
      );     
      
    SET @alter_query := CONCAT('ALTER TABLE ', @table_name_new, ' ADD COLUMN ', @column_name, ' VARCHAR(255) DEFAULT NULL;');
    PREPARE stmt FROM @alter_query;
    EXECUTE stmt;
    DEALLOCATE PREPARE stmt;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240618224805__Update_UpdateOnlineEnquiryFlywayHistory () $$
DROP PROCEDURE IF EXISTS V20240618224805__Update_UpdateOnlineEnquiryFlywayHistory $$
DELIMITER ;