CREATE TABLE `bill_scholarship_received` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `billId` BIGINT(20) NULL DEFAULT NULL,
  `scholarshipReceivedId` BIGINT(20) NULL DEFAULT NULL,
  `feeAmount` DOUBLE NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX `Refbillheader3233_idx` (`billId` ASC),
  INDEX `RefScholershipawardee3376_idx` (`scholarshipReceivedId` ASC),
  INDEX `Refuser3423_idx` (`lastUpdatedBy` ASC),
  PRIMARY KEY (`id`),
  CONSTRAINT `Refbillheader3233`
    FOREIGN KEY (`billId`)
    REFERENCES `bill_header` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `RefScholershipawardee3376`
    FOREIGN KEY (`scholarshipReceivedId`)
    REFERENCES `scholarship_awardees` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Refuser3423`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);