CREATE TABLE `marksheet_job_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `marksheetJobId` bigint(20) NOT NULL,
  `programBatchId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  `isMarksheetPrint` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`id`),
  KEY `fk_marksheet_job_details_1_idx` (`marksheetJobId`),
  KEY `fk_marksheet_job_details_2_idx` (`programBatchId`),
  KEY `fk_marksheet_job_details_3_idx` (`periodId`),
  KEY `fk_marksheet_job_details_4_idx` (`sectionId`),
  KEY `fk_marksheet_job_details_5_idx` (`admissionId`),
  CONSTRAINT `fk_marksheet_job_details_1` FOREIGN KEY (`marksheetJobId`) REFERENCES `marksheetJob` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_details_2` FOREIGN KEY (`programBatchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_details_3` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_details_4` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_details_5` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
