CREATE TABLE `trans_journey_assignment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceRouteId` bigint(20) NOT NULL,
  `vehicleId` bigint(20) NOT NULL,
  `dateOfJourney` date DEFAULT NULL,
  `assignStatus` varchar(45) DEFAULT NULL,
  `completionStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refserviceroute_idx` (`serviceRouteId`),
  KEY `RefVehicleToJourney_idx` (`vehicleId`),
  KEY `RefJourneyUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefJourneyUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `Refserviceroute` FOREIGN KEY (`serviceRouteId`) REFERENCES `trans_service_route` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `RefVehicleToJourney_idx` FOREIGN KEY (`vehicleId`) REFERENCES `trans_vehicle` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

