CREATE 
   OR REPLACE
VIEW `sponsorship_awardee_listing` AS
    select 
        `sponsors`.`id` AS `SPONSORID`,
        `sponsors`.`sponsorshipCode` AS `SPONSOR_CODE`,
        `sponsors`.`sponsorName` AS `SPONSOR_NAME`,
        `sponsorship_awardees`.`id` AS `ID`,
        `users`.`code` AS `STUDENT_CODE`,
        `users`.`firstName` AS `FULL_NAME`,
        `users`.`middleName` AS `MIDDLE_NAME`,
        `users`.`lastName` AS `LAST_NAME`,
        `batches`.`batchName` AS `BATCH`,
        `programs`.`programName` AS `PROGRAM`,
        `academy_location`.`academyName` AS `ACADEMY`,
        `academy_location`.`locationName` AS `LOCATION`,
		`academy_location`.`academyId` AS `ACADEMY_ID`,
		`academy_location`.`locationId` AS `LOCATION_ID`,
        sum(`sponsorship_installments`.`amount`) AS `TOTAL_AMOUNT`,
        ifnull(`fee_adjustment_details`.`adjustedAmount`,
                0) AS `ADJUSTMENT_AMOUNT`,
        (sum(`sponsorship_installments`.`amount`) - ifnull(sum(`fee_adjustment_details`.`adjustedAmount`),
                0)) AS `BALANCE_AMOUNT`,
        `sponsors`.`id` AS `S_ID`,
        `admission`.`id` AS `ADMISSIONID`,
        `users`.`id` AS `STUDENT_ID`,
        `sponsors`.`sponsorType` AS `SPONSOR_TYPE`
    from
        (((((((((((((((`sponsorship_awarded_items`
        left join `sponsorship_installments` ON ((`sponsorship_awarded_items`.`id` = `sponsorship_installments`.`sponsorshipAwardedItemId`)))
        left join `sponsorship_awardees` ON ((`sponsorship_awarded_items`.`sponsorshipAwardeeId` = `sponsorship_awardees`.`id`)))
        left join `sponsors` ON ((`sponsorship_awarded_items`.`sponsorId` = `sponsors`.`id`)))
        left join `bill_fee_plan_rule_stage` ON ((`sponsorship_installments`.`id` = `bill_fee_plan_rule_stage`.`sponsorshipInstallmentId`)))
        left join `fee_adjustment_details` ON ((`bill_fee_plan_rule_stage`.`id` = `fee_adjustment_details`.`billFeeRuleStageId`)))
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `admission` ON ((`sponsorship_awarded_items`.`admissionId` = `admission`.`id`)))
        left join `prog_batch_period_config` ON ((`admission`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `academy_location` ON ((`admission`.`academyLocationId` = `academy_location`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` ON ((`students`.`userId` = `users`.`id`)))
        left join `currency` ON ((`receipt_header`.`currencyId` = `currency`.`id`)))
    group by `sponsors`.`id` , `admission`.`id`;