CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_top_and_bottom_course_absenteeism` AS
    select 
        concat(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        `course_variants`.`courseVariantCode` AS `courseVariantCode`,
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`courseId` AS `courseId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `student_attendance_dashboard_section_wise`.`courseVariantId` AS `courseVariantId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`,
        `student_attendance_dashboard_section_wise`.`date` AS `date`
    from
        (((`student_attendance_dashboard_section_wise`
        left join `courses` ON ((`student_attendance_dashboard_section_wise`.`courseId` = `courses`.`id`)))
        left join `course_variants` ON ((`student_attendance_dashboard_section_wise`.`courseVariantId` = `course_variants`.`id`)))
        left join `academy_location` ON ((`student_attendance_dashboard_section_wise`.`academyLocationId` = `academy_location`.`id`)))
    where
        (`student_attendance_dashboard_section_wise`.`courseVariantId` is not null)
    group by `student_attendance_dashboard_section_wise`.`courseVariantId`;