
CREATE TABLE `examination_remark` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `remark` VARCHAR(512) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_examination_remark_lastUpdatedBy_user01_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_examination_remark_lastUpdatedBy_user01`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`, `tableName`, `masterName`, `moduleName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, 'examination_remark', 'EXAMINATION_REMARK','Examinations', 0, 0, '1',@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@ItemsMaxId+1, 'remark', 'REMARK', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',@currentTimeStamp);



ALTER TABLE `grade_type` 
CHANGE COLUMN `gradeType` `gradeType` VARCHAR(255) NULL DEFAULT NULL ;

ALTER TABLE `grade` 
CHANGE COLUMN `gradeType` `gradeType` VARCHAR(255) NULL DEFAULT NULL ;

ALTER TABLE `evaluation_sequence_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `periodName`;


ALTER TABLE `evaluation_plan_level_two_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `marksObtainedFrom`;

ALTER TABLE `evaluation_plan_level_one_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `periodName`;

ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `maxMarksOrGrade`;

ALTER TABLE `evaluation_period_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `creditGradePointSum`;

ALTER TABLE `evaluation_program_rank` 
ADD COLUMN `absentDashStatus` VARCHAR(60) NULL DEFAULT NULL AFTER `creditGradePointSum`;
