Drop View if exists fee_dashboard_bill_userwise_applicant_detail_first;
Drop View if exists fee_dashboard_bill_userwise_applicant_detail_second;
Drop View if exists fee_dashboard_bill_userwise_sponsor_detail_first;
Drop View if exists fee_dashboard_bill_userwise_sponsor_detail_second;
Drop View if exists fee_dashboard_bill_userwise_student_detail_first;
Drop View if exists fee_dashboard_bill_userwise_student_detail_second;
Drop View if exists fee_dashboard_collection_userwise_applicant_detail_first;
Drop View if exists fee_dashboard_collection_userwise_applicant_detail_second;
Drop View if exists fee_dashboard_collection_userwise_student_detail_first;
Drop View if exists fee_dashboard_collection_userwise_student_detail_second;
Drop View if exists fee_dashboard_collection_userwise_sponsor_detail_first;
Drop View if exists fee_dashboard_collection_userwise_sponsor_detail_second;
Drop View if exists fee_dashboard_outstanding_userwise_applicant_detail_first;
Drop View if exists fee_dashboard_outstanding_userwise_applicant_detail_second;
Drop View if exists fee_dashboard_outstanding_userwise_sponsor_detail_first;
Drop View if exists fee_dashboard_outstanding_userwise_sponsor_detail_second;
Drop View if exists fee_dashboard_outstanding_userwise_student_detail_first;
Drop View if exists fee_dashboard_outstanding_userwise_student_detail_second;
Drop View if exists fee_dashboard_refund_userwise_applicant_detail_first;
Drop View if exists fee_dashboard_refund_userwise_applicant_detail_second;
Drop View if exists fee_dashboard_refund_userwise_student_detail_first;
Drop View if exists fee_dashboard_refund_userwise_student_detail_second;

CREATE OR REPLACE VIEW  `fee_dashboard_bill_userwise_applicant_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `application`.`id` AS `applicantId`,
         `application`.`code` AS `applicationNumber`,
         `bill_header`.`id` AS `billId`
    FROM
        ((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `application` ON (( `bill_header`.`applicantId` =  `application`.`id`)))
        LEFT JOIN  `application_program` ON (( `application`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON (( `application`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`applicantId` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Application' , 'Program')));

CREATE OR REPLACE VIEW  `fee_dashboard_bill_userwise_program_applicant_detail_first` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `application`.`id` AS `applicantId`,
         `application`.`id` AS `totalApplicant`
    FROM
        ((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `application` ON (( `bill_header`.`applicantId` =  `application`.`id`)))
        LEFT JOIN  `application_program` ON (( `application`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON (( `application`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`applicantId` IS NOT NULL)
            AND ( `bill_header`.`billStatus` IN ('SETTLED' , 'PARTLY_SETTLED', 'FULLY_PENDING'))
            AND ( `fee_plan_type`.`feePlanType` = 'Program'));

CREATE OR REPLACE VIEW  `fee_dashboard_bill_userwise_sponsor_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `students`.`userId` AS `studentId`,
         `bill_header`.`id` AS `billId`,
         `sponsors`.`sponsorName` AS `sponsorName`,
         `sponsors`.`sponsorshipCode` AS `code`,
         `sponsors`.`id` AS `sponsorId`
    FROM
        (((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `students` ON (( `bill_fee_plan_rule_stage`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
        LEFT JOIN  `sponsors` ON (( `bill_header`.`sponsorId` =  `sponsors`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`sponsorId` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_bill_userwise_student_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `students`.`userId` AS `studentId`,
         `admission`.`code` AS `admisionNumber`,
         `bill_header`.`id` AS `billId`
    FROM
        ((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `students` ON (( `bill_header`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`studentId` IS NOT NULL)
            AND ISNULL( `bill_header`.`sponsorId`)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_collection_userwise_applicant_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `application` `a` ON (( `bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN  `application_program` ON ((`a`.`id` =  `application_program`.`applicationId`)))
                        LEFT JOIN  `applicant_person` ON ((`a`.`applicantPersonId` =  `applicant_person`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` =  `application`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        ( `fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `application` `a` ON (( `bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN  `application_program` ON ((`a`.`id` =  `application_program`.`applicationId`)))
                        LEFT JOIN  `applicant_person` ON ((`a`.`applicantPersonId` =  `applicant_person`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` =  `application`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `receipt_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `receipt_header`.`currencyId` AS `currencyId`,
         `application`.`id` AS `applicationId`,
         `receipt_header`.`id` AS `receiptHeaderId`,
         `application`.`code` AS `applicationNumber`
    FROM
        ((((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `receipt_header` ON (( `fee_adjustment_master`.`receiptHeaderId` =  `receipt_header`.`id`)))
        LEFT JOIN  `receipt_payment_instrument` ON (( `receipt_header`.`id` =  `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `application` ON (( `bill_header`.`applicantId` =  `application`.`id`)))
        LEFT JOIN  `application_program` ON (( `application`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON (( `application`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `application`.`id` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Application' , 'Program')));

CREATE OR REPLACE VIEW  `fee_dashboard_collection_userwise_program_applicant_detail_first` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `application` `a` ON (( `bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN  `application_program` ON ((`a`.`id` =  `application_program`.`applicationId`)))
                        LEFT JOIN  `applicant_person` ON ((`a`.`applicantPersonId` =  `applicant_person`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` =  `application`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        ( `fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `application` `a` ON (( `bill_header`.`applicantId` = `a`.`id`)))
                        LEFT JOIN  `application_program` ON ((`a`.`id` =  `application_program`.`applicationId`)))
                        LEFT JOIN  `applicant_person` ON ((`a`.`applicantPersonId` =  `applicant_person`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`a`.`id` =  `application`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `receipt_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `receipt_header`.`currencyId` AS `currencyId`,
         `application`.`id` AS `applicationId`,
         `application`.`id` AS `totalApplicant`
    FROM
        ((((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `receipt_header` ON (( `fee_adjustment_master`.`receiptHeaderId` =  `receipt_header`.`id`)))
        LEFT JOIN  `receipt_payment_instrument` ON (( `receipt_header`.`id` =  `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `application` ON (( `bill_header`.`applicantId` =  `application`.`id`)))
        LEFT JOIN  `application_program` ON (( `application`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON (( `application`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `application`.`id` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` = 'Program'))
    GROUP BY  `batches`.`id`;

CREATE OR REPLACE VIEW  `fee_dashboard_collection_userwise_sponsor_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` `p` ON (( `fee_adjustment_master`.`paymentHeaderId` = `p`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `students` `s` ON (( `bill_fee_plan_rule_stage`.`studentId` = `s`.`userId`)))
                        LEFT JOIN  `admission` ON ((`s`.`userId` =  `admission`.`studentId`)))
                        LEFT JOIN  `persons` ON ((`s`.`personId` =  `persons`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
                        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
                        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
                        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
                        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` =  `students`.`userId`)
                            AND (`p`.`sponsorId` =  `sponsors`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        ( `fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                         `fee_adjustment_details`.`adjustedAmount`
                    FROM
                        (((((((((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` `p` ON (( `fee_adjustment_master`.`paymentHeaderId` = `p`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `students` `s` ON (( `bill_fee_plan_rule_stage`.`studentId` = `s`.`userId`)))
                        LEFT JOIN  `admission` ON ((`s`.`userId` =  `admission`.`studentId`)))
                        LEFT JOIN  `persons` ON ((`s`.`personId` =  `persons`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
                        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
                        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
                        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
                        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` =  `students`.`userId`)
                            AND (`p`.`sponsorId` =  `sponsors`.`id`)
                            AND (`feestageheadconfig`.`id` =  `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `receipt_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `receipt_header`.`currencyId` AS `currencyId`,
         `sponsors`.`sponsorName` AS `sponsorName`,
         `sponsors`.`sponsorshipCode` AS `code`,
         `sponsors`.`id` AS `sponsorId`,
         `receipt_header`.`id` AS `receiptHeaderId`
    FROM
        (((((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `receipt_header` ON (( `fee_adjustment_master`.`receiptHeaderId` =  `receipt_header`.`id`)))
        LEFT JOIN  `receipt_payment_instrument` ON (( `receipt_header`.`id` =  `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `students` ON (( `bill_header`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
        LEFT JOIN  `sponsors` ON (( `receipt_header`.`sponsorId` =  `sponsors`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `receipt_header`.`sponsorId` IS NOT NULL)
            AND ISNULL( `receipt_header`.`studentId`)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_collection_userwise_student_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        IFNULL((SELECT 
                        SUM( `fee_adjustment_details`.`adjustedAmount`)
                    FROM
                        (((((((((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feeStageHeadConfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `students` `s` ON (( `bill_header`.`studentId` = `s`.`userId`)))
                        LEFT JOIN  `admission` ON ((`s`.`userId` =  `admission`.`studentId`)))
                        LEFT JOIN  `persons` ON ((`s`.`personId` =  `persons`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
                        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
                        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
                        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
                        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` =  `students`.`userId`)
                            AND (`feeStageHeadConfig`.`id` =  `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        ( `fee_adjustment_details`.`adjustedAmount` - IFNULL((SELECT 
                        SUM( `fee_adjustment_details`.`adjustedAmount`)
                    FROM
                        (((((((((((((((((((( `fee_adjustment_details`
                        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
                        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
                        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_stage_head_config` `feeStageHeadConfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        LEFT JOIN  `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` =  `fee_heads`.`id`)))
                        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
                        LEFT JOIN  `students` `s` ON (( `bill_header`.`studentId` = `s`.`userId`)))
                        LEFT JOIN  `admission` ON ((`s`.`userId` =  `admission`.`studentId`)))
                        LEFT JOIN  `persons` ON ((`s`.`personId` =  `persons`.`id`)))
                        LEFT JOIN  `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
                        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
                        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
                        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
                            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
                        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
                        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
                        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
                        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
                        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
                        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
                    WHERE
                        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            AND (`s`.`userId` =  `students`.`userId`)
                            AND (`feeStageHeadConfig`.`id` =  `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `receipt_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `receipt_header`.`currencyId` AS `currencyId`,
         `students`.`userId` AS `studentId`,
         `receipt_header`.`id` AS `receiptHeaderId`,
         `admission`.`code` AS `admisionNumber`
    FROM
        ((((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `receipt_header` ON (( `fee_adjustment_master`.`receiptHeaderId` =  `receipt_header`.`id`)))
        LEFT JOIN  `receipt_payment_instrument` ON (( `receipt_header`.`id` =  `receipt_payment_instrument`.`receiptHeaderId`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `students` ON (( `bill_header`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `students`.`userId` IS NOT NULL)
            AND ISNULL( `receipt_header`.`sponsorId`)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_outstanding_userwise_applicant_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `application`.`id` AS `applicantId`,
         `application`.`code` AS `applicationNumber`,
         `bill_header`.`id` AS `billId`
    FROM
        ((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `application` ON (( `bill_header`.`applicantId` =  `application`.`id`)))
        LEFT JOIN  `application_program` ON (( `application`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON (( `application`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`applicantId` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Application' , 'Program')));

CREATE OR REPLACE VIEW  `fee_dashboard_outstanding_userwise_sponsor_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `students`.`userId` AS `studentId`,
         `bill_header`.`id` AS `billId`,
         `sponsors`.`sponsorName` AS `sponsorName`,
         `sponsors`.`sponsorshipCode` AS `code`,
         `sponsors`.`id` AS `sponsorId`
    FROM
        (((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `students` ON (( `bill_fee_plan_rule_stage`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
        LEFT JOIN  `sponsors` ON (( `bill_header`.`sponsorId` =  `sponsors`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`sponsorId` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_outstanding_userwise_student_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
         `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
         `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `bill_header`.`billingDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `bill_header`.`currencyId` AS `currencyId`,
         `students`.`userId` AS `studentId`,
         `admission`.`code` AS `admisionNumber`,
         `bill_header`.`id` AS `billId`
    FROM
        ((((((((((((((((( `bill_header`
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `bill_header`.`id` =  `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN  `fee_stage_head_config` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` =  `fee_stage_head_config`.`id`)))
        LEFT JOIN  `fee_heads` ON (( `fee_stage_head_config`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `students` ON (( `bill_header`.`studentId` =  `students`.`userId`)))
        LEFT JOIN  `admission` ON (( `students`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON (( `students`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON (( `fee_stage_head_config`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND ( `bill_header`.`studentId` IS NOT NULL)
            AND ISNULL( `bill_header`.`sponsorId`)
            AND ( `bill_header`.`billStatus` IN ('SETTLED' , 'PARTLY_SETTLED', 'FULLY_PENDING'))
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));

CREATE OR REPLACE VIEW  `fee_dashboard_refund_userwise_applicant_summary` AS
    SELECT 
         `fee_adjustment_details`.`adjustedAmount` AS `amount`,
         `applicant_person`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `payment_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `payment_header`.`currencyId` AS `currencyId`,
        `a`.`id` AS `applicantId`,
        `a`.`code` AS `applicationNumber`
    FROM
        (((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `application` `a` ON (( `bill_header`.`applicantId` = `a`.`id`)))
        LEFT JOIN  `application_program` ON ((`a`.`id` =  `application_program`.`applicationId`)))
        LEFT JOIN  `applicant_person` ON ((`a`.`applicantPersonId` =  `applicant_person`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `application_program`.`progBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
            AND (`a`.`id` IS NOT NULL)
            AND ( `fee_plan_type`.`feePlanType` IN ('Application' , 'Program')));

CREATE OR REPLACE VIEW  `fee_dashboard_refund_userwise_student_summary` AS
    SELECT 
         `fee_heads`.`feeHeadName` AS `feeHeadName`,
         `fee_adjustment_details`.`adjustedAmount` AS `Amount`,
         `persons`.`printName` AS `printName`,
         `fee_plan_type`.`feePlanType` AS `feePlanType`,
         `programs`.`programName` AS `programName`,
         `batches`.`batchName` AS `batchName`,
         `academies`.`academyName` AS `academyName`,
         `locations`.`locationName` AS `locationName`,
         `payment_header`.`transactionDate` AS `transactionDate`,
         `fee_heads`.`id` AS `feeHeadId`,
         `fee_plan_type`.`id` AS `feePlanTypeId`,
         `programs`.`id` AS `programId`,
         `batches`.`id` AS `batchId`,
         `academies`.`id` AS `academyId`,
         `locations`.`id` AS `locationId`,
         `academy_location`.`id` AS `academyLocationId`,
         `payment_header`.`currencyId` AS `currencyId`,
        `s`.`userId` AS `studentId`,
         `admission`.`code` AS `admisionNumber`
    FROM
        (((((((((((((((((((( `fee_adjustment_details`
        LEFT JOIN  `fee_adjustment_master` ON (( `fee_adjustment_details`.`adjustmentMasterId` =  `fee_adjustment_master`.`id`)))
        LEFT JOIN  `payment_header` ON (( `fee_adjustment_master`.`paymentHeaderId` =  `payment_header`.`id`)))
        LEFT JOIN  `bill_fee_plan_rule_stage` ON (( `fee_adjustment_details`.`billFeeRuleStageId` =  `bill_fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_stage_head_config` `feestageheadconfig` ON (( `bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feestageheadconfig`.`id`)))
        LEFT JOIN  `fee_heads` ON ((`feestageheadconfig`.`feeHeadId` =  `fee_heads`.`id`)))
        LEFT JOIN  `bill_header` ON (( `fee_adjustment_details`.`billHeaderId` =  `bill_header`.`id`)))
        LEFT JOIN  `students` `s` ON (( `bill_header`.`studentId` = `s`.`userId`)))
        LEFT JOIN  `admission` ON ((`s`.`userId` =  `admission`.`studentId`)))
        LEFT JOIN  `persons` ON ((`s`.`personId` =  `persons`.`id`)))
        LEFT JOIN  `fee_plan_rule_stage` ON ((`feestageheadconfig`.`feePlanRuleStageId` =  `fee_plan_rule_stage`.`id`)))
        LEFT JOIN  `fee_plan_rules` ON (( `fee_plan_rule_stage`.`feePlanRuleId` =  `fee_plan_rules`.`id`)))
        LEFT JOIN  `fee_plan` ON (( `fee_plan_rules`.`feePlanId` =  `fee_plan`.`id`)))
        LEFT JOIN  `fee_plan_acad_locations` ON ((( `fee_plan`.`id` =  `fee_plan_acad_locations`.`feePlanId`)
            AND ( `admission`.`programBatchSeatConfigId` =  `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN  `prog_batch_seat_config` ON (( `fee_plan_acad_locations`.`progBatchSeatConfigId` =  `prog_batch_seat_config`.`id`)))
        LEFT JOIN  `batches` ON (( `prog_batch_seat_config`.`programBatchId` =  `batches`.`id`)))
        LEFT JOIN  `programs` ON (( `batches`.`programId` =  `programs`.`id`)))
        LEFT JOIN  `fee_plan_type` ON (( `fee_plan`.`feePlanType` =  `fee_plan_type`.`id`)))
        LEFT JOIN  `academy_location` ON (( `programs`.`academyLocationId` =  `academy_location`.`id`)))
        LEFT JOIN  `academies` ON (( `academy_location`.`academyId` =  `academies`.`id`)))
        LEFT JOIN  `locations` ON (( `academy_location`.`locationId` =  `locations`.`id`)))
    WHERE
        (( `bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
            AND (`s`.`userId` IS NOT NULL)
            AND ISNULL( `payment_header`.`sponsorId`)
            AND ( `fee_plan_type`.`feePlanType` IN ('Program' , 'Services', 'Courses', 'Exam')));


