create table marksheet_job_old select * from marksheet_job;
create table marksheet_job_details_old select * from marksheet_job_details;
create table marksheet_job_variant_levels_old select * from marksheet_job_variant_levels;

CREATE TABLE `marksheet_job_sub_level` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `marksheetJobSubLevelName` VARCHAR(45) NOT NULL,
  `marksheetJobId` BIGINT(20) NOT NULL,
  `jobStatus` VARCHAR(60) NULL DEFAULT NULL,
  `templateId` BIGINT(20) NULL,
  `version` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
CONSTRAINT `primary_key_levelName_and_job_id` UNIQUE (marksheetJobSubLevelName,marksheetJobId),
  PRIMARY KEY (`id`),
  INDEX `fk_marksheet_job_sub_level_1_idx` (`marksheetJobId` ASC),
  INDEX `fk_marksheet_job_sub_level_2_idx` (`templateId` ASC),
  INDEX `fk_marksheet_job_sub_level_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_marksheet_job_sub_level_1`
    FOREIGN KEY (`marksheetJobId`)
    REFERENCES `marksheet_job` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_sub_level_2`
    FOREIGN KEY (`templateId`)
    REFERENCES `report_template_configuration` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_marksheet_job_sub_level_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


ALTER TABLE `marksheet_job` 
CHANGE COLUMN `jobName` `jobName` VARCHAR(255) NULL DEFAULT NULL COMMENT '' ,
ADD COLUMN `programBatchId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `templateId`,
ADD COLUMN `periodId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `programBatchId`,
ADD COLUMN `isConsolidated` BIT(1) NULL DEFAULT NULL COMMENT '' AFTER `periodId`,
ADD CONSTRAINT `primary_key_jobName_periodId_and_batchId` UNIQUE (jobName,programBatchId,periodId),
ADD INDEX `fk_marksheet_job_batch_3_idx` (`programBatchId` ASC)  COMMENT '',
ADD INDEX `fk_marksheet_job_period_4_idx` (`periodId` ASC)  COMMENT '';
ALTER TABLE `marksheet_job` 
ADD CONSTRAINT `fk_marksheet_job_batch_3`
  FOREIGN KEY (`programBatchId`)
  REFERENCES `batches` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_marksheet_job_period_4`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  
ALTER TABLE `marksheet_job_details` 
ADD COLUMN `marksheetJobSubLevelId` BIGINT(20) NULL COMMENT '' AFTER `id`,
ADD INDEX `fk_marksheet_job_details_6_idx` (`marksheetJobSubLevelId` ASC)  COMMENT '';

ALTER TABLE `marksheet_job_details` 
ADD CONSTRAINT `fk_marksheet_job_details_6`
  FOREIGN KEY (`marksheetJobSubLevelId`)
  REFERENCES `marksheet_job_sub_level` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


ALTER TABLE `marksheet_job_variant_levels` 
ADD COLUMN `marksheetJobSubLevelId` BIGINT(20) NULL DEFAULT NULL COMMENT '' AFTER `id`,
ADD INDEX `fk_marksheet_job_variant_levels_9_idx` (`marksheetJobSubLevelId` ASC)  COMMENT '';
ALTER TABLE `marksheet_job_variant_levels` 
ADD CONSTRAINT `fk_marksheet_job_variant_levels_9`
  FOREIGN KEY (`marksheetJobSubLevelId`)
  REFERENCES `marksheet_job_sub_level` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  

DROP PROCEDURE IF EXISTS marksheetDataAlter;
DELIMITER $$
CREATE PROCEDURE marksheetDataAlter()
	BEGIN
     DECLARE marksheetJobId BIGINT(20);
     DECLARE marksheetJobSubLevelName varchar(255);
     DECLARE marksheetJobStatus varchar(255);
     DECLARE templateId BIGINT(20);
     DECLARE marksheetJobSubLevelMaxId BIGINT(20);
     DECLARE programBatchId BIGINT(20);
     DECLARE periodId BIGINT(20);
     DECLARE marksheetJobDetailMaxId BIGINT(20);
declare marksheet_no_more_rows boolean default false;
START TRANSACTION;

 BLOCK1: begin
DECLARE allMarksheetJobIds CURSOR FOR
	select marksheet_job.id from marksheet_job group By marksheet_job.id;
           
 declare continue handler for not found  set marksheet_no_more_rows := true;
	OPEN allMarksheetJobIds;
		allMarksheetJobIds: LOOP
		fetch allMarksheetJobIds into marksheetJobId;
      
    if marksheet_no_more_rows then 
        close allMarksheetJobIds;
        leave allMarksheetJobIds;
     end if;
            
		select marksheet_job.jobName, marksheet_job.templateId, marksheet_job.jobStatus
    into marksheetJobSubLevelName, templateId, marksheetJobStatus
    from marksheet_job where marksheet_job.id=marksheetJobId
    group By marksheet_job.id;
 
 
			INSERT INTO `marksheet_job_sub_level` 
            (`marksheetJobSubLevelName`, `marksheetJobId`, `jobStatus`, `templateId`, `version`, `lastUpdatedBy`)
            VALUES (marksheetJobSubLevelName, marksheetJobId,marksheetJobStatus, templateId, '0', '1');

			select max(marksheet_job_sub_level.id) into marksheetJobSubLevelMaxId from marksheet_job_sub_level;

UPDATE `marksheet_job_details` SET `marksheetJobSubLevelId`=marksheetJobSubLevelMaxId
 WHERE `marksheet_job_details`.`marksheetJobId`=marksheetJobId;

UPDATE `marksheet_job_variant_levels` SET `marksheetJobSubLevelId`=marksheetJobSubLevelMaxId
 WHERE `marksheet_job_variant_levels`.`marksheetJobId`=marksheetJobId;

	
			select max(marksheet_job_details.id) into marksheetJobDetailMaxId from marksheet_job_details
            where `marksheet_job_details`.`marksheetJobId`=marksheetJobId;
			
            select marksheet_job_details.programBatchId, marksheet_job_details.periodId
    into programBatchId, periodId
    from marksheet_job_details where marksheet_job_details.id=marksheetJobDetailMaxId;
            

UPDATE `marksheet_job` SET `programBatchId`=programBatchId, `periodId`=periodId, `isConsolidated`=0
 WHERE `marksheet_job`.`id`=marksheetJobId;
 
 
			END LOOP allMarksheetJobIds;

	END BLOCK1;

COMMIT;      
END$$
DELIMITER ;


call marksheetDataAlter();  
DROP PROCEDURE IF EXISTS marksheetDataAlter;
  
  
  ALTER TABLE `marksheet_job` 
DROP FOREIGN KEY `fk_marksheet_Job_1`;
ALTER TABLE `marksheet_job` 
DROP COLUMN `templateId`,
DROP COLUMN `jobId`,
DROP COLUMN `jobStatus`,
DROP INDEX `fk_marksheet_Job_11_idx` ;
  
  
  ALTER TABLE `marksheet_job_details` 
DROP FOREIGN KEY `fk_marksheet_job_details_3`,
DROP FOREIGN KEY `fk_marksheet_job_details_2`,
DROP FOREIGN KEY `fk_marksheet_job_details_1`;
ALTER TABLE `marksheet_job_details` 
DROP COLUMN `periodId`,
DROP COLUMN `programBatchId`,
DROP COLUMN `marksheetJobId`,
DROP INDEX `fk_marksheet_job_details_3_idx` ,
DROP INDEX `fk_marksheet_job_details_2_idx` ,
DROP INDEX `fk_marksheet_job_details_1_idx` ;

  
  ALTER TABLE `marksheet_job_variant_levels` 
DROP FOREIGN KEY `fk_marksheet_job_variant_levels_6`;
ALTER TABLE `marksheet_job_variant_levels` 
DROP COLUMN `marksheetJobId`,
DROP INDEX `fk_marksheet_job_variant_levels_6_idx` ;
