CREATE TABLE `social_login_integration`
( 
`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
`socialLogin` VARCHAR(255) NOT NULL,
`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
 PRIMARY KEY (`id`), 
CONSTRAINT `social_login_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `social_login_academia_integration`
(
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `socialId` BIGINT(20) NOT NULL,
 `socailClientId` TEXT NOT NULL,
 `socialClientSecret` TEXT NOT NULL,
 `socialRedirectUrl` TEXT NOT NULL,
 `lastUpdatedBy` BIGINT(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `social_academia_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
  CONSTRAINT `social_academia_socialId_FK` FOREIGN KEY (`socialId`) REFERENCES `social_login_integration`(`id`) 
 ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`,`filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES ('social_login_academia_integration', 'SOCIAL_LOGIN_ACADEMIA_INTEGRATION', 'Social Login Setup','MASTER_WITH_AL',0, 0, '1', SYSDATE());
 
 SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('socialId', 'SOCIAL_LOGIN', @standardMasterMaxId, 'Varchar', '1', 1, 'social_login_integration', 'id','socialLogin', 0, 0, 0, '1', SYSDATE()),
('socailClientId', 'CLIENT_ID', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('socialClientSecret', 'CLIENT_SECRET', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('socialRedirectUrl', 'REDIRECT_URL', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE());


INSERT INTO `social_login_integration` (`id`, `socialLogin`, `lastUpdatedBy`) VALUES ('1', 'Facebook', '1'); 
INSERT INTO `social_login_integration` (`id`, `socialLogin`, `lastUpdatedBy`) VALUES ('2', 'Google', '1'); 