CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `mark_entry_report` AS 
    select 
        `examination_result_history`.`id` AS `examResultHistoryId`,
        `users`.`id` AS `userId`,
        `academy_location`.`id` AS `academyLocationId`,
        `sections`.`id` AS `sectionId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `batches`.`id` AS `batchId`,
        `programs`.`id` AS `programId`,
        `eval_seq_detail`.`id` AS `eventId`,
        `evaluation_plan`.`id` AS `evaluationPlanId`,
        `course_variants`.`id` AS `courseVariantId`,
        `courses`.`id` AS `courseId`,
        `examination_result_history`.`admissionId` AS `admissionId`,
        `users`.`printName` AS `userName`,
        `user_groups`.`userGroupName` AS `userGroupName`,
        `users`.`status` AS `userStatus`,
        `examination_result_history`.`lastUpdate` AS `markEntryTime`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`sectionCode` AS `sectionName`,
        `course_variants`.`courseVariantCode` AS `courseVariantName`,
        `courses`.`courseName` AS `courseName`,
        `studentUser`.`printName` AS `studentName`,
        `studentUser`.`id` AS `studentUserId`,
        `admission`.`code` AS `admissionCode`,
        `eval_seq_detail`.`detailSequenceNumber` AS `eventName`,
        `evaluation_plan`.`evaluationPlanNumber` AS `planName`,
        (case
            when (`eval_seq_detail`.`evalInMarksOrGrade` like 'MARK') then `examination_result_history`.`effectiveMarks`
            else `examination_result_history`.`finalGrade`
        end) AS `finalMarks`,
        `examination_result_history`.`status` AS `resultStatus`,
        `users`.`whetherInternal` AS `userType`,
        `users`.`code` AS `userCode`,
        `academy_location`.`displayName` AS `academyLocationName`,
        `students`.`personId` AS `personId`,
        `admission`.`programBatchSeatConfigId` AS `seatConfigId`
    from
        (((((((((((((((((`examination_result_history`
        left join `users` ON ((`examination_result_history`.`lastUpdatedBy` = `users`.`id`)))
        left join `admission` ON ((`examination_result_history`.`admissionId` = `admission`.`id`)))
        left join `user_groups` ON ((`users`.`userGroupId` = `user_groups`.`id`)))
        left join `sections` ON ((`examination_result_history`.`sectionId` = `sections`.`id`)))
        left join `prog_batch_period_config` ON ((`sections`.`periodId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `course_variants` ON ((`examination_result_history`.`courseVariantId` = `course_variants`.`id`)))
        left join `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        left join `academy_location` ON (((`programs`.`academyLocationId` = `academy_location`.`id`)
            and (`admission`.`academyLocationId` = `academy_location`.`id`))))
        left join `eval_seq_detail` ON ((`examination_result_history`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        left join `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        left join `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        left join `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` `studentUser` ON ((`students`.`userId` = `studentUser`.`id`)));
