-- Unique records query

SET @OLD_SQL_SAFE_UPDATES = @@SQL_SAFE_UPDATES;
SET SQL_SAFE_UPDATES =0;

-- examination result
CREATE TABLE IF NOT EXISTS examination_result_old select * from examination_result;
DROP TABLE IF EXISTS `marksheet_job_old`;
DROP TABLE IF EXISTS `marksheet_job_details_old`;
DROP TABLE IF EXISTS `marksheet_job_variant_levels_old`;

delete from examination_result where evaluationDetailSequenceId is null or admissionId is null;
delete from evaluation_sequence_rank where evaluationSequenceId is null or admissionId is null;
delete from evaluation_plan_level_one_rank where evaluationPlanLevelOneId is null or admissionId is null;
delete from evaluation_plan_level_two_rank where evaluationPlanLevelTwoId is null or admissionId is null;
delete from evaluation_plan_rank where evaluationPlanId is  null or admissionId is null;
delete from evaluation_period_rank where periodId is null or admissionId is null;
delete from evaluation_program_rank where batchId is null or admissionId is null;

delete from examination_result_history where examinationResultId in(
select a.id FROM examination_result a
 inner join examination_result dup where 
 a.evaluationDetailSequenceId=dup.evaluationDetailSequenceId
 and a.admissionId=dup.admissionId
 and a.id<dup.id);
 
delete a FROM examination_result a
 inner join examination_result dup where 
 a.evaluationDetailSequenceId=dup.evaluationDetailSequenceId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
                
ALTER TABLE `examination_result` 
DROP FOREIGN KEY `Refadmission738`,
DROP FOREIGN KEY `Refeval_seq_detail1700`;
ALTER TABLE `examination_result` 
CHANGE COLUMN `evaluationDetailSequenceId` `evaluationDetailSequenceId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `exam_result_unique_record1` (`evaluationDetailSequenceId` ASC, `admissionId` ASC);
ALTER TABLE `examination_result` 
ADD CONSTRAINT `Refadmission738`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`),
ADD CONSTRAINT `Refeval_seq_detail1700`
  FOREIGN KEY (`evaluationDetailSequenceId`)
  REFERENCES `eval_seq_detail` (`id`);
                
-- method rank
delete a FROM evaluation_sequence_rank a
 inner join evaluation_sequence_rank dup where 
 a.evaluationSequenceId=dup.evaluationSequenceId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
                
ALTER TABLE `evaluation_sequence_rank` 
DROP FOREIGN KEY `fk_admissionId_3`,
DROP FOREIGN KEY `fk_evaluationSequenceId_3`;
ALTER TABLE `evaluation_sequence_rank` 
CHANGE COLUMN `evaluationSequenceId` `evaluationSequenceId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `method_rank_unique_record` (`evaluationSequenceId` ASC, `admissionId` ASC);
ALTER TABLE `evaluation_sequence_rank` 
ADD CONSTRAINT `fk_admissionId_3`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluationSequenceId_3`
  FOREIGN KEY (`evaluationSequenceId`)
  REFERENCES `evaluation_sequence` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- level 2 rank

delete a FROM evaluation_plan_level_two_rank a
 inner join evaluation_plan_level_two_rank dup where 
 a.evaluationPlanLevelTwoId=dup.evaluationPlanLevelTwoId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
                
ALTER TABLE `evaluation_plan_level_two_rank` 
DROP FOREIGN KEY `fk_admissionId_2`,
DROP FOREIGN KEY `fk_evaluationPlanLevelTwoId_2`;
ALTER TABLE `evaluation_plan_level_two_rank` 
CHANGE COLUMN `evaluationPlanLevelTwoId` `evaluationPlanLevelTwoId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `evel_plan_level_two_unique_record` (`evaluationPlanLevelTwoId` ASC, `admissionId` ASC);
ALTER TABLE `evaluation_plan_level_two_rank` 
ADD CONSTRAINT `fk_admissionId_2`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluationPlanLevelTwoId_2`
  FOREIGN KEY (`evaluationPlanLevelTwoId`)
  REFERENCES `evaluation_plan_level_two` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- level 1 rank

delete a FROM evaluation_plan_level_one_rank a
 inner join evaluation_plan_level_one_rank dup where 
 a.evaluationPlanLevelOneId=dup.evaluationPlanLevelOneId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
 
ALTER TABLE `evaluation_plan_level_one_rank` 
DROP FOREIGN KEY `fk_admissionId_1`,
DROP FOREIGN KEY `fk_evaluationPlanLevelOneId_1`;
ALTER TABLE `evaluation_plan_level_one_rank` 
CHANGE COLUMN `evaluationPlanLevelOneId` `evaluationPlanLevelOneId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `evel_plan_level_one_unique_record` (`evaluationPlanLevelOneId` ASC, `admissionId` ASC);
ALTER TABLE `evaluation_plan_level_one_rank` 
ADD CONSTRAINT `fk_admissionId_1`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluationPlanLevelOneId_1`
  FOREIGN KEY (`evaluationPlanLevelOneId`)
  REFERENCES `evaluation_plan_level_one` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- plan rank

delete a FROM evaluation_plan_rank a
 inner join evaluation_plan_rank dup where 
 a.evaluationPlanId=dup.evaluationPlanId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
 
 ALTER TABLE `evaluation_plan_rank` 
DROP FOREIGN KEY `fk_admissionId`,
DROP FOREIGN KEY `fk_evaluationPlanId`;
ALTER TABLE `evaluation_plan_rank` 
CHANGE COLUMN `evaluationPlanId` `evaluationPlanId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `evel_plan_unique_record` (`evaluationPlanId` ASC, `admissionId` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_admissionId`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluationPlanId`
  FOREIGN KEY (`evaluationPlanId`)
  REFERENCES `evaluation_plan` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- period rank

delete a FROM evaluation_period_rank a
 inner join evaluation_period_rank dup where 
 a.periodId=dup.periodId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
 
ALTER TABLE `evaluation_period_rank` 
DROP FOREIGN KEY `fk_evaluation_period_rank_1`,
DROP FOREIGN KEY `fk_evaluation_period_rank_2`;
ALTER TABLE `evaluation_period_rank` 
CHANGE COLUMN `periodId` `periodId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `period_rank_unique_record` (`periodId` ASC, `admissionId` ASC);
ALTER TABLE `evaluation_period_rank` 
ADD CONSTRAINT `fk_evaluation_period_rank_1`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluation_period_rank_2`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- program rank

delete a FROM evaluation_program_rank a
 inner join evaluation_program_rank dup where 
 a.batchId=dup.batchId
 and a.admissionId=dup.admissionId
 and a.id<dup.id;
 
ALTER TABLE `evaluation_program_rank` 
DROP FOREIGN KEY `fk_admissionId_4`,
DROP FOREIGN KEY `fk_evaluation_program_rank_1`;
ALTER TABLE `evaluation_program_rank` 
CHANGE COLUMN `admissionId` `admissionId` BIGINT(20) NOT NULL ,
CHANGE COLUMN `batchId` `batchId` BIGINT(20) NOT NULL ,
ADD UNIQUE INDEX `prog_rank_unique_record` (`admissionId` ASC, `batchName` ASC);
ALTER TABLE `evaluation_program_rank` 
ADD CONSTRAINT `fk_admissionId_4`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_evaluation_program_rank_1`
  FOREIGN KEY (`batchId`)
  REFERENCES `batches` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
-- marksheet data

delete a FROM marksheet a
 inner join marksheet dup where 
 a.studentId=dup.studentId
 and a.admissionId=dup.admissionId
 and a.courseVariantId=dup.courseVariantId
 and a.evaluationPlanId=dup.evaluationPlanId
 and a.evaluationPlanLevelOneId=dup.evaluationPlanLevelOneId
 and a.evaluationPlanLevelTwoId=dup.evaluationPlanLevelTwoId
 and a.evaluationPlanThreeId=dup.evaluationPlanThreeId
 and a.evaluationPlanLevelFourId=dup.evaluationPlanLevelFourId
 and a.programId=dup.programId
 and a.batchId=dup.batchId
 and a.periodId=dup.periodId
 and a.sectionId=dup.sectionId
 and a.courseId=dup.courseId
 and a.id<dup.id;
 
ALTER TABLE `marksheet` 
ADD UNIQUE INDEX `marksheet_unique_record` (`admissionId` ASC, `studentId` ASC,
 `courseVariantId` ASC, `evaluationPlanId` ASC, `evaluationPlanLevelOneId` ASC,
 `evaluationPlanLevelTwoId` ASC, `evaluationPlanThreeId` ASC, `evaluationPlanLevelFourId` ASC,
 `programId` ASC, `batchId` ASC, `periodId` ASC, `sectionId` ASC, `courseId` ASC);

SET SQL_SAFE_UPDATES = @OLD_SQL_SAFE_UPDATES;
