
CREATE TABLE `exam_result_event_students` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_result_student_event_unique_record1` (`admissionId`,`eventId`,`sectionId`,`courseVariantId`),
  KEY `exam_result_student_event001` (`admissionId`),
  KEY `exam_result_student_event002` (`eventId`),
  KEY `exam_result_student_event003` (`courseVariantId`),
  KEY `exam_result_student_event004` (`sectionId`),
  KEY `exam_result_student_event005` (`lastUpdatedBy`),
  CONSTRAINT `exam_result_student_event001` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `exam_result_student_event002` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
  CONSTRAINT `exam_result_student_event003` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `exam_result_student_event004` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `exam_result_student_event005` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
