ALTER TABLE `group_schedule_batch` 
DROP INDEX `group_schedule_batch_unique_check` ,
ADD UNIQUE INDEX `group_schedule_batch_unique_check` (`evaluationGroupId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC, `batchName` ASC);

ALTER TABLE `eval_group_center` 
DROP INDEX `eval_group_center_unique_check` ,
ADD UNIQUE INDEX `eval_group_center_unique_check` (`evaluationGroupId` ASC, `centerId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC);

ALTER TABLE `eval_group_sch_date` 
DROP INDEX `eval_group_sch_date_unique_check` ,
ADD UNIQUE INDEX `eval_group_sch_date_unique_check` (`evaluationGroupId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC, `scheduleDate` ASC);

ALTER TABLE `group_batch_seat_type` 
ADD COLUMN `evaluationGroupId` BIGINT(20) NULL DEFAULT NULL AFTER `id`,
DROP INDEX `group_batch_seat_type_unique_check` ,
ADD UNIQUE INDEX `group_batch_seat_type_unique_check` (`evaluationGroupId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC, `progBatchSeatConfigId` ASC),
ADD INDEX `fk_group_batch_seat_type_evalGroupId_idx_idx` (`evaluationGroupId` ASC);
ALTER TABLE `group_batch_seat_type` 
ADD CONSTRAINT `fk_group_batch_seat_type_evalGroupId_idx`
  FOREIGN KEY (`evaluationGroupId`)
  REFERENCES `evaluation_group` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `group_date_batch_center` 
ADD UNIQUE INDEX `group_date_batch_center_unique_check` (`evalGroupSchDateId` ASC, `evalGroupSchBatchId` ASC, `evalGroupSchCenterId` ASC);

ALTER TABLE `examiner_allocation` 
DROP INDEX `examiner_allocation_unique_check` ,
ADD UNIQUE INDEX `examiner_allocation_unique_check` (`roleId` ASC, `userId` ASC, `evalPlanDetailSeqId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC, `evaluationGroupId` ASC);


ALTER TABLE `exam_result_event_students` 
DROP INDEX `exam_result_student_event_unique_record1` ,
ADD UNIQUE INDEX `exam_result_student_event_unique_record1` (`eventId` ASC, `admissionId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC);

ALTER TABLE `examination_result` 
DROP INDEX `exam_result_unique_record1` ,
ADD UNIQUE INDEX `exam_result_unique_record1` (`evaluationDetailSequenceId` ASC, `admissionId` ASC, `courseVariantId` ASC, `sectionId` ASC, `periodId` ASC);

ALTER TABLE `evaluation_sequence_rank` 
DROP INDEX `method_rank_unique_record` ,
ADD UNIQUE INDEX `method_rank_unique_record` (`evaluationSequenceId` ASC, `admissionId` ASC, `sectionId` ASC, `periodId` ASC, `courseVariantId` ASC);

ALTER TABLE `evaluation_plan_level_two_rank` 
DROP INDEX `evel_plan_level_two_unique_record` ,
ADD UNIQUE INDEX `evel_plan_level_two_unique_record` (`evaluationPlanLevelTwoId` ASC, `admissionId` ASC, `sectionId` ASC, `periodId` ASC, `courseVariantId` ASC);

ALTER TABLE `evaluation_plan_level_one_rank` 
DROP INDEX `evel_plan_level_one_unique_record` ,
ADD UNIQUE INDEX `evel_plan_level_one_unique_record` (`evaluationPlanLevelOneId` ASC, `admissionId` ASC, `sectionId` ASC, `periodId` ASC, `courseVariantId` ASC);

ALTER TABLE `evaluation_plan_rank` 
DROP INDEX `evel_plan_unique_record` ,
ADD UNIQUE INDEX `evel_plan_unique_record` (`evaluationPlanId` ASC, `admissionId` ASC, `sectionId` ASC, `periodId` ASC, `courseVariantId` ASC);

ALTER TABLE `eval_group_sequences` 
DROP INDEX `eval_group_sequences_unique_check` ,
ADD UNIQUE INDEX `eval_group_sequences_unique_check` (`evaluationGroupId` ASC, `periodId` ASC, `sectionId` ASC, `courseVariantId` ASC, `evalSequenceDetailId` ASC);
