CREATE TABLE `mobile_erp_configuration`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`academyLocationId` BIGINT(20), 
	 `isDefault` BIT(1),
	 `isActive` BIT(1),
	 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	 `lastUpdatedBy` BIGINT(20),
	  PRIMARY KEY (`id`), 
	  CONSTRAINT `mobile_erp_configuration_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`), 
	  CONSTRAINT `mobile_erp_configuration_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`) ) ENGINE=InnoDB DEFAULT 

CHARSET=utf8; 


INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`, `filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES ('mobile_erp_configuration', 'MOBILE_ERP_CONFIGURATION', 'Mobile Setup','MASTER_WITH_AL', 0, 0, '1', SYSDATE());
 
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, 

`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId, 'Varchar', '1', 1, 'academy_location', 'id','academyLocationName', 0, 0, 1, '1', SYSDATE()),
('isDefault','IS_DEFAULT',@standardMasterMaxId,'Boolean','2',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('isActive','IS_ACTIVE',@standardMasterMaxId,'Boolean','3',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

