CREATE TABLE IF NOT EXISTS `file_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_file_type_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_file_type_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fileTypeId` bigint(20) NOT NULL,
  `fileNumber` varchar(255) NOT NULL,
  `fileSubject` varchar(255) NOT NULL,
  `fileOwner` bigint(20) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `dueDate` datetime DEFAULT NULL,
  `priority` bigint(20) DEFAULT NULL,
  `otherDetail` TEXT DEFAULT NULL,
  `remarks` TEXT DEFAULT NULL,
  `currentStatus` varchar(20) DEFAULT NULL,
  `updateReason` TEXT DEFAULT NULL,
  `statusChangeDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_file_info_fileTypeId` (`fileTypeId`),
  KEY `fk_file_info_fileOwner` (`fileOwner`),
  KEY `fk_file_info_priority` (`priority`),
  KEY `fk_file_info_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_file_info_fileTypeId` FOREIGN KEY (`fileTypeId`) REFERENCES `file_type` (`id`),
  CONSTRAINT `fk_file_info_fileOwner` FOREIGN KEY (`fileOwner`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_file_info_priority` FOREIGN KEY (`priority`) REFERENCES `drop_down` (`id`),
  CONSTRAINT `fk_file_info_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_academy_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fileId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_file_academy_location_fileId` (`fileId`),
  KEY `fk_file_academy_location_academyLocationId` (`academyLocationId`),
  KEY `fk_file_academy_location_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_file_academy_location_fileId` FOREIGN KEY (`fileId`) REFERENCES `file_info` (`id`),
  CONSTRAINT `fk_file_academy_location_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_file_academy_location_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fileId` bigint(20) NOT NULL,
  `documentId` bigint(20) NOT NULL,
  `uploadedBy` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_file_document_fileId` (`fileId`),
  KEY `fk_file_document_documentId` (`documentId`),
  KEY `fk_file_document_uploadedBy` (`uploadedBy`),
  KEY `fk_file_document_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_file_document_fileId` FOREIGN KEY (`fileId`) REFERENCES `file_info` (`id`),
  CONSTRAINT `fk_file_document_documentId` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_file_document_uploadedBy` FOREIGN KEY (`uploadedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_file_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `file_assignment_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fileId` bigint(20) NOT NULL,
  `assignedUser` bigint(20) NOT NULL,
  `assignmentDate` datetime NOT NULL,
  `dueDate` datetime DEFAULT NULL,
  `remarks` TEXT DEFAULT NULL,
  `fileStatus` varchar(20) DEFAULT NULL,
  `acknowledgement` varchar(20) DEFAULT NULL,
  `fileHandoverBy` bigint(20) NOT NULL,
  `receivedDate` datetime DEFAULT NULL,
  `returnReason` TEXT DEFAULT NULL,
  `returnDate` datetime DEFAULT NULL,
  `resubmissionDueDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_file_assignment_detail_fileId` (`fileId`),
  KEY `fk_file_assignment_detail_assignedUser` (`assignedUser`),
  KEY `fk_file_assignment_detail_fileHandoverBy` (`fileHandoverBy`),
  KEY `fk_file_assignment_detail_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_file_assignment_detail_fileId` FOREIGN KEY (`fileId`) REFERENCES `file_info` (`id`),
  CONSTRAINT `fk_file_assignment_detail_assignedUser` FOREIGN KEY (`assignedUser`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_file_assignment_detail_fileHandoverBy` FOREIGN KEY (`fileHandoverBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_file_assignment_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
