CREATE TABLE `class_teacher_student_remarks` (
  `id` BIGINT(20) NOT NULL ,
  `admissionId` BIGINT(20) NOT NULL,
  `periodId` BIGINT(20) NULL,
  `batchId` BIGINT(20) NULL,
  `remark` VARCHAR(512) NULL,
  `levelName` VARCHAR(50) NULL,
  `levelValue` VARCHAR(256) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_class_teacher_student_remarks_adm_id` (`admissionId` ASC),
  INDEX `fk_class_teacher_student_remarks_period_id` (`periodId` ASC),
  INDEX `fk_class_teacher_student_remarks_batch_id` (`batchId` ASC),
  INDEX `fk_class_teacher_student_remarks_lastUpdatedBy_id` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_class_teacher_student_remarks_adm_id`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_class_teacher_student_remarks_period_id`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_class_teacher_student_remarks_batch_id`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_class_teacher_student_remarks_lastUpdatedBy_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

ALTER TABLE `class_teacher_student_remarks` 
CHANGE COLUMN `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT ;
